/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.WebAlarmRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.view.RedirectView;

public class AlarmDetailController
extends MultiActionController {
    private WebAlarmRepository m_webAlarmRepository;
    private Alarm m_alarm;
    private Logger logger = LoggerFactory.getLogger((String)("OpenNMS.WEB." + AlarmDetailController.class.getName()));

    public void setWebAlarmRepository(WebAlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug("AlarmDetailController handleRequestInternal called");
        return super.handleRequestInternal(request, response);
    }

    public ModelAndView detail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        List<OnmsAcknowledgment> acknowledgments = null;
        try {
            alarmIdString = httpServletRequest.getParameter("id");
            int alarmId = Integer.parseInt(alarmIdString);
            acknowledgments = this.m_webAlarmRepository.getAcknowledgments(alarmId);
            this.m_alarm = this.m_webAlarmRepository.getAlarm(alarmId);
            this.logger.debug("Alarm retrieved: '{}'", (Object)this.m_alarm.toString());
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("id"));
        }
        catch (Exception e) {
            this.logger.error("Could not retrieve alarm from webAlarmRepository for ID='{}'", (Object)alarmIdString);
        }
        ModelAndView mv = new ModelAndView("alarm/detail");
        mv.addObject("alarm", (Object)this.m_alarm);
        mv.addObject("alarmId", (Object)alarmIdString);
        mv.addObject("acknowledgments", acknowledgments);
        return mv;
    }

    public ModelAndView clearSticky(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeStickyMemo(alarmId);
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveSticky(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String stickyMemoBody = httpServletRequest.getParameter("stickyMemoBody");
            this.m_webAlarmRepository.updateStickyMemo(alarmId, stickyMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView clearJournal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            this.m_webAlarmRepository.removeReductionKeyMemo(alarmId);
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }

    public ModelAndView saveJournal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String alarmIdString = "";
        try {
            alarmIdString = httpServletRequest.getParameter("alarmId");
            int alarmId = Integer.parseInt(alarmIdString);
            String journalMemoBody = httpServletRequest.getParameter("journalMemoBody");
            this.m_webAlarmRepository.updateReductionKeyMemo(alarmId, journalMemoBody, httpServletRequest.getRemoteUser());
            return new ModelAndView((View)new RedirectView("detail.htm", true), "id", (Object)alarmId);
        }
        catch (NumberFormatException e) {
            this.logger.error("Could not parse alarm ID '{}' to integer.", (Object)httpServletRequest.getParameter("alarmId"));
            throw new ServletException("Could not parse alarm ID " + httpServletRequest.getParameter("alarmId") + " to integer.");
        }
    }
}

