/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReport;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.web.controller.admin.support.FormatterNotFoundException;
import org.opennms.web.controller.admin.support.FormatterView;
import org.opennms.web.controller.admin.support.SystemReportInfo;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class SystemReportController
extends AbstractController
implements InitializingBean {
    private SystemReport m_systemReport;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        if (!StringUtils.hasText((String)operation)) {
            operation = "list";
        }
        LogUtils.debugf((Object)((Object)this), (String)"Calling operation %s in SystemReportController", (Object[])new Object[]{operation});
        if ("run".equalsIgnoreCase(operation)) {
            SystemReportFormatter formatter = null;
            String formatterName = request.getParameter("formatter");
            for (SystemReportFormatter f : this.m_systemReport.getFormatters()) {
                if (!f.getName().equals(formatterName)) continue;
                formatter = f;
                break;
            }
            if (formatter == null) {
                throw new FormatterNotFoundException("Unable to locate formatter plugin for format type '" + formatterName + "'");
            }
            List<String> selectedPlugins = Arrays.asList(request.getParameterValues("plugins"));
            ArrayList<SystemReportPlugin> plugins = new ArrayList<SystemReportPlugin>();
            for (SystemReportPlugin plugin : this.m_systemReport.getPlugins()) {
                if (!selectedPlugins.contains(plugin.getName())) continue;
                plugins.add(plugin);
            }
            return new ModelAndView((View)new FormatterView(formatter), "report", (Object)new SystemReportInfo(Arrays.asList(formatter), plugins));
        }
        return new ModelAndView("redirect:/admin/support/systemReportList.htm");
    }

    public void setSystemReport(SystemReport report) {
        this.m_systemReport = report;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_systemReport);
    }
}

