/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.context.HttpServletRequestContext;
import org.extremecomponents.table.limit.LimitFactory;
import org.extremecomponents.table.limit.TableLimit;
import org.extremecomponents.table.limit.TableLimitFactory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.svclayer.outage.OutageListBuilder;
import org.opennms.web.svclayer.outage.OutageService;
import org.opennms.web.svclayer.outage.OutagesFilteringView;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class OutageListController
extends AbstractController
implements InitializingBean {
    private static final int ROW_LIMIT = 25;
    private OutageService m_outageService;
    private OutageListBuilder m_outageListBuilder;
    private String m_successView;
    private int m_defaultRowsDisplayed = 25;
    private OutagesFilteringView m_filterView;

    public void setOutageService(OutageService service) {
        this.m_outageService = service;
    }

    public void setFilterView(OutagesFilteringView filterView) {
        this.m_filterView = filterView;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse reply) throws Exception {
        String sortOrder;
        String orderProperty;
        Integer rowend;
        Integer rowstart;
        HttpServletRequestContext context = new HttpServletRequestContext(request);
        TableLimitFactory limitFactory = new TableLimitFactory((Context)context, "tabledata");
        TableLimit limit = new TableLimit((LimitFactory)limitFactory);
        HashMap<String, Object> myModel = new HashMap<String, Object>();
        if (limit.getPage() == 1) {
            rowstart = 0;
            rowend = this.getDefaultRowsDisplayed();
        } else {
            rowstart = limit.getPage() * this.getDefaultRowsDisplayed() + 1 - this.getDefaultRowsDisplayed();
            rowend = this.getDefaultRowsDisplayed();
        }
        OnmsCriteria criteria = this.m_filterView.buildCriteria(request);
        OnmsCriteria countCriteria = this.m_filterView.buildCriteria(request);
        if (limit.getSort().getProperty() == null) {
            orderProperty = "outageid";
            sortOrder = "desc";
        } else {
            orderProperty = limit.getSort().getProperty();
            sortOrder = limit.getSort().getSortOrder();
        }
        Collection<OnmsOutage> foundOutages = this.m_outageService.getOutagesByRange(rowstart, rowend, orderProperty, sortOrder, criteria);
        myModel.put("tabledata", this.m_outageListBuilder.theTable(foundOutages));
        myModel.put("totalRows", this.m_outageService.getOutageCount(countCriteria));
        return new ModelAndView(this.getSuccessView(), myModel);
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public String getSuccessView() {
        return this.m_successView;
    }

    public void setDefaultRowsDisplayed(int defaultRowsDisplayed) {
        this.m_defaultRowsDisplayed = defaultRowsDisplayed;
    }

    public int getDefaultRowsDisplayed() {
        return this.m_defaultRowsDisplayed;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_filterView, (String)"filterView property must be set");
        Assert.notNull((Object)this.m_outageListBuilder, (String)"outageListBuilder property must be set");
    }

    public void setOutageListBuilder(OutageListBuilder outageListBuilder) {
        this.m_outageListBuilder = outageListBuilder;
    }
}

