/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.schedule;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.poller.BasicSchedule;
import org.opennms.netmgt.config.poller.Outage;
import org.opennms.netmgt.config.poller.Outages;

public class ScheduleEditorServlet
extends HttpServlet {
    private static final long serialVersionUID = -7117332637559031820L;
    private Map<String, ScheduleOp> m_ops = new HashMap<String, ScheduleOp>();
    private Map<String, SingleMapping> m_maps = new HashMap<String, SingleMapping>();
    private ScheduleOp m_defaultOp = new DisplayOp();
    private ScheduleMapping m_defaultMapping;
    private String m_defaultView;

    public ScheduleEditorServlet() {
        this.m_ops.put("", this.m_defaultOp);
        this.m_ops.put("edit", new EditOp());
        this.m_ops.put("delete", new DeleteOp());
        this.m_ops.put("display", new DisplayOp());
        this.m_defaultMapping = new SingleMapping("/admin/schedule/displaySchedules.jsp");
        this.m_maps.put("", new SingleMapping("/admin/schedule/displaySchedules.jsp"));
        this.m_maps.put("edit", new SingleMapping("/admin/schedule/editSchedule.jsp"));
        this.m_defaultView = "/admin/schedule/displaySchedules.jsp";
    }

    ScheduleOp getOp(String cmd) {
        if (cmd == null) {
            return this.m_defaultOp;
        }
        ScheduleOp op = this.m_ops.get(cmd);
        if (op == null) {
            throw new IllegalArgumentException("Unrecognized operation " + cmd);
        }
        return op;
    }

    ScheduleMapping getMap(String cmd) {
        if (cmd == null) {
            return this.m_defaultMapping;
        }
        ScheduleMapping map = this.m_maps.get(cmd);
        if (map == null) {
            return this.m_defaultMapping;
        }
        return map;
    }

    void showView(HttpServletRequest request, HttpServletResponse response, String view) throws ServletException, IOException {
        String nextView = view;
        if (nextView == null) {
            nextView = this.m_defaultView;
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(view);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ScheduleOp op = this.getOp(request.getParameter("op"));
        ScheduleMapping map = this.getMap(request.getParameter("op"));
        String view = op.doOp(request, response, map);
        this.showView(request, response, view);
    }

    private ScheduleManager getSchedMgr(HttpServletRequest request) throws ServletException {
        ScheduleManager schedMgr = (ScheduleManager)request.getSession().getAttribute("schedMgr");
        String fileName = request.getParameter("file");
        if (schedMgr == null || fileName != null && !fileName.equals(schedMgr.getFileName())) {
            schedMgr = new OutageManager();
            schedMgr.setFileName(fileName);
            request.getSession().setAttribute("schedMgr", (Object)schedMgr);
        }
        schedMgr.loadSchedules();
        return schedMgr;
    }

    static class SingleMapping
    implements ScheduleMapping {
        String m_view;

        public SingleMapping(String view) {
            this.m_view = view;
        }

        @Override
        public String get(String result) {
            return this.m_view;
        }
    }

    static interface ScheduleMapping {
        public String get(String var1);
    }

    class DisplayOp
    implements ScheduleOp {
        DisplayOp() {
        }

        @Override
        public String doOp(HttpServletRequest request, HttpServletResponse response, ScheduleMapping map) throws ServletException {
            return map.get("success");
        }
    }

    class DeleteOp
    implements ScheduleOp {
        DeleteOp() {
        }

        @Override
        public String doOp(HttpServletRequest request, HttpServletResponse response, ScheduleMapping map) throws ServletException {
            ScheduleManager schedMgr = ScheduleEditorServlet.this.getSchedMgr(request);
            int schedIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("scheduleIndex"));
            schedMgr.deleteSchedule(schedIndex);
            schedMgr.saveSchedules();
            return map.get("success");
        }
    }

    class EditOp
    implements ScheduleOp {
        EditOp() {
        }

        @Override
        public String doOp(HttpServletRequest request, HttpServletResponse response, ScheduleMapping map) throws ServletException {
            ScheduleManager schedMgr = ScheduleEditorServlet.this.getSchedMgr(request);
            int schedIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("scheduleIndex"));
            request.getSession().setAttribute("currentSchedIndex", (Object)request.getParameter("scheduleIndex"));
            request.getSession().setAttribute("currentSchedule", (Object)schedMgr.getSchedule(schedIndex));
            return map.get("success");
        }
    }

    class NewScheduleOp
    implements ScheduleOp {
        NewScheduleOp() {
        }

        @Override
        public String doOp(HttpServletRequest request, HttpServletResponse response, ScheduleMapping map) throws ServletException {
            ScheduleManager schedMgr = ScheduleEditorServlet.this.getSchedMgr(request);
            int schedIndex = WebSecurityUtils.safeParseInt((String)request.getParameter("scheduleIndex"));
            request.getSession().setAttribute("currentSchedIndex", (Object)request.getParameter("scheduleIndex"));
            request.getSession().setAttribute("currentSchedule", (Object)schedMgr.getSchedule(schedIndex));
            return map.get("success");
        }
    }

    static interface ScheduleOp {
        public String doOp(HttpServletRequest var1, HttpServletResponse var2, ScheduleMapping var3) throws ServletException;
    }

    static class OutageManager
    implements ScheduleManager {
        private Outages m_outages;
        private String m_fileName = null;

        OutageManager() {
        }

        @Override
        public void loadSchedules() throws ServletException {
            if (this.m_fileName == null) {
                throw new ServletException("Loading from outage factory not implemented yet!");
            }
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.m_fileName), "UTF-8");
                this.m_outages = (Outages)CastorUtils.unmarshal(Outages.class, (Reader)reader);
                ((Reader)reader).close();
            }
            catch (MarshalException e) {
                throw new ServletException("Unable to unmarshal " + this.m_fileName, (Throwable)e);
            }
            catch (ValidationException e) {
                throw new ServletException("Invalid xml in file " + this.m_fileName, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Unable to locate file " + this.m_fileName, (Throwable)e);
            }
            catch (IOException e) {
                throw new ServletException("Error reading file " + this.m_fileName, (Throwable)e);
            }
        }

        @Override
        public void saveSchedules() throws ServletException {
            if (this.m_fileName == null) {
                throw new ServletException("Saving to outage factory not implemented yet!");
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_fileName), "UTF-8");
                Marshaller.marshal((Object)this.m_outages, (Writer)writer);
                ((Writer)writer).close();
            }
            catch (MarshalException e) {
                throw new ServletException("Unable to unmarshal " + this.m_fileName, (Throwable)e);
            }
            catch (ValidationException e) {
                throw new ServletException("Invalid xml in file " + this.m_fileName, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Unable to locate file " + this.m_fileName, (Throwable)e);
            }
            catch (IOException e) {
                throw new ServletException("Error reading file " + this.m_fileName, (Throwable)e);
            }
        }

        @Override
        public void deleteSchedule(int index) throws ServletException {
            List<Outage> outages = this.getOutages();
            outages.remove(index);
        }

        private List<Outage> getOutages() {
            return this.m_outages.getOutageCollection();
        }

        @Override
        public void addSchedule(BasicSchedule schedule) throws ServletException {
            Outage outage = (Outage)schedule;
            this.m_outages.addOutage(outage);
        }

        @Override
        public void setSchedule(int index, BasicSchedule schedule) throws ServletException {
            this.m_outages.setOutage(index, (Outage)schedule);
        }

        @Override
        public BasicSchedule createSchedule(String name, String type) {
            Outage outage = new Outage();
            outage.setName(name);
            outage.setType(type);
            return outage;
        }

        @Override
        public BasicSchedule getSchedule(int index) {
            return this.m_outages.getOutage(index);
        }

        @Override
        public BasicSchedule[] getSchedule() {
            return this.m_outages.getOutage();
        }

        @Override
        public String getFileName() {
            return this.m_fileName;
        }

        @Override
        public void setFileName(String fileName) {
            this.m_fileName = fileName;
        }
    }

    public static interface ScheduleManager {
        public String getFileName();

        public void setFileName(String var1);

        public void loadSchedules() throws ServletException;

        public void saveSchedules() throws ServletException;

        public void deleteSchedule(int var1) throws ServletException;

        public void addSchedule(BasicSchedule var1) throws ServletException;

        public void setSchedule(int var1, BasicSchedule var2) throws ServletException;

        public BasicSchedule createSchedule(String var1, String var2);

        public BasicSchedule getSchedule(int var1);

        public BasicSchedule[] getSchedule();
    }
}

