/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.roles;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.WebCalendar;
import org.opennms.netmgt.config.WebRole;
import org.opennms.netmgt.config.WebRoleContext;
import org.opennms.netmgt.config.WebRoleManager;

public class UserRoleServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 1078908981395901414L;
    private static final String LIST = "/roles/list.jsp";
    private static final String VIEW = "/roles/view.jsp";

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reqUrl = request.getServletPath();
        request.setAttribute("reqUrl", (Object)reqUrl);
        Action action = this.getAction(request, response);
        String display = action.execute(request, response);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(display);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private Action getAction(HttpServletRequest request, HttpServletResponse response) {
        String op = request.getParameter("operation");
        if ("view".equals(op)) {
            return new ViewAction();
        }
        return new ListAction();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doIt(request, response);
    }

    public void init() throws ServletException {
        super.init();
        try {
            WebRoleContext.init();
            this.getServletContext().setAttribute("roleManager", (Object)WebRoleContext.getWebRoleManager());
            this.getServletContext().setAttribute("userManager", (Object)WebRoleContext.getWebUserManager());
            this.getServletContext().setAttribute("groupManager", (Object)WebRoleContext.getWebGroupManager());
        }
        catch (Throwable e) {
            throw new ServletException("Error initializing RolesServlet", e);
        }
    }

    private WebRoleManager getRoleManager() {
        return WebRoleContext.getWebRoleManager();
    }

    private class ViewAction
    implements Action {
        private ViewAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            try {
                String dateSpec;
                WebRole role = (WebRole)request.getAttribute("role");
                if (role == null) {
                    role = UserRoleServlet.this.getRoleManager().getRole(request.getParameter("role"));
                    request.setAttribute("role", (Object)role);
                }
                Date month = (dateSpec = request.getParameter("month")) == null ? new Date() : new SimpleDateFormat("MM-yyyy").parse(dateSpec);
                WebCalendar calendar = role.getCalendar(month);
                request.setAttribute("calendar", (Object)calendar);
                return UserRoleServlet.VIEW;
            }
            catch (ParseException e) {
                throw new ServletException("Unable to parse date: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private class ListAction
    implements Action {
        private ListAction() {
        }

        @Override
        public String execute(HttpServletRequest request, HttpServletResponse response) {
            return UserRoleServlet.LIST;
        }
    }

    private static interface Action {
        public String execute(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;
    }
}

