/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.admin.nodeManagement.ManagedInterface;
import org.opennms.web.admin.nodeManagement.ManagedService;

public class GetNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = 9083494959783285766L;
    private static final String INTERFACE_QUERY = "SELECT nodeid, ipaddr, isManaged FROM ipinterface WHERE ismanaged in ('M','A','U','F') AND ipaddr <> '0.0.0.0' ORDER BY nodeid, case when (ipaddr ~ E'^([0-9]{1,3}\\.){3}[0-9]{1,3}$') then inet(ipaddr) else null end, ipaddr";
    private static final String SERVICE_QUERY = "SELECT ifservices.serviceid, servicename, status FROM ifservices, service WHERE nodeid=? AND ipaddr=? AND status in ('A','U','F', 'S', 'R') AND ifservices.serviceid = service.serviceid ORDER BY servicename";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession user = request.getSession(true);
        try {
            user.setAttribute("listAll.manage.jsp", this.getAllNodes(user));
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/manage.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ManagedInterface> getAllNodes(HttpSession userSession) throws SQLException {
        Connection connection = null;
        ArrayList<ManagedInterface> allNodes = new ArrayList<ManagedInterface>();
        int lineCount = 0;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            PreparedStatement ifaceStmt = connection.prepareStatement(INTERFACE_QUERY);
            d.watch((Object)ifaceStmt);
            ResultSet ifaceResults = ifaceStmt.executeQuery();
            d.watch((Object)ifaceResults);
            if (ifaceResults != null) {
                while (ifaceResults.next()) {
                    ++lineCount;
                    ManagedInterface newInterface = new ManagedInterface();
                    allNodes.add(newInterface);
                    newInterface.setNodeid(ifaceResults.getInt(1));
                    newInterface.setAddress(ifaceResults.getString(2));
                    newInterface.setStatus(ifaceResults.getString(3));
                    PreparedStatement svcStmt = connection.prepareStatement(SERVICE_QUERY);
                    d.watch((Object)svcStmt);
                    svcStmt.setInt(1, newInterface.getNodeid());
                    svcStmt.setString(2, newInterface.getAddress());
                    ResultSet svcResults = svcStmt.executeQuery();
                    d.watch((Object)svcResults);
                    if (svcResults == null) continue;
                    while (svcResults.next()) {
                        ++lineCount;
                        ManagedService newService = new ManagedService();
                        newService.setId(svcResults.getInt(1));
                        newService.setName(svcResults.getString(2));
                        newService.setStatus(svcResults.getString(3));
                        newInterface.addService(newService);
                    }
                }
            }
            userSession.setAttribute("lineItems.manage.jsp", (Object)lineCount);
        }
        finally {
            d.cleanUp();
        }
        return allNodes;
    }
}

