/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.dashboard.client.Alarm;
import org.opennms.dashboard.client.NodeRtc;
import org.opennms.dashboard.client.Notification;
import org.opennms.dashboard.client.SurveillanceData;
import org.opennms.dashboard.client.SurveillanceGroup;
import org.opennms.dashboard.client.SurveillanceService;
import org.opennms.dashboard.client.SurveillanceSet;
import org.opennms.dashboard.server.CriteriaAddingVisitor;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.NotificationDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.svclayer.ProgressMonitor;
import org.opennms.web.svclayer.RtcService;
import org.opennms.web.svclayer.SimpleWebTable;
import org.opennms.web.svclayer.support.RtcNodeModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class DefaultSurveillanceService
implements SurveillanceService,
InitializingBean {
    private NodeDao m_nodeDao;
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private NotificationDao m_notificationDao;
    private org.opennms.web.svclayer.SurveillanceService m_webSurveillanceService;
    private SurveillanceViewConfigDao m_surveillanceViewConfigDao;
    private CategoryDao m_categoryDao;
    private AlarmDao m_alarmDao;
    private RtcService m_rtcService;
    private GroupDao m_groupDao;
    private OutageDao m_outageDao;

    @Override
    public SurveillanceData getSurveillanceData() {
        SurveillanceData data = new SurveillanceData();
        SimpleWebTable table = this.m_webSurveillanceService.createSurveillanceTable(this.getView().getName(), new ProgressMonitor());
        data.setName(this.getView().getName());
        ArrayList<SurveillanceGroup> columnGroups = new ArrayList<SurveillanceGroup>();
        for (SimpleWebTable.Cell columnHeader : table.getColumnHeaders().subList(1, table.getColumnHeaders().size())) {
            SurveillanceGroup columnGroup = new SurveillanceGroup();
            columnGroup.setId(columnHeader.getContent().toString());
            columnGroup.setLabel(columnHeader.getContent().toString());
            columnGroup.setColumn(true);
            columnGroups.add(columnGroup);
        }
        data.setColumnGroups(columnGroups.toArray(new SurveillanceGroup[columnGroups.size()]));
        ArrayList<SurveillanceGroup> rowGroups = new ArrayList<SurveillanceGroup>();
        for (List<SimpleWebTable.Cell> row : table.getRows()) {
            SimpleWebTable.Cell rowHeader = row.get(0);
            SurveillanceGroup rowGroup = new SurveillanceGroup();
            rowGroup.setId(rowHeader.getContent().toString());
            rowGroup.setLabel(rowHeader.getContent().toString());
            rowGroups.add(rowGroup);
        }
        data.setRowGroups(rowGroups.toArray(new SurveillanceGroup[rowGroups.size()]));
        int rowIndex = 0;
        for (List<SimpleWebTable.Cell> row : table.getRows()) {
            int columnIndex = 0;
            for (SimpleWebTable.Cell cell : row.subList(1, row.size())) {
                data.setCell(rowIndex, columnIndex, cell.getContent().toString(), cell.getStyleClass());
                ++columnIndex;
            }
            ++rowIndex;
        }
        data.setComplete(true);
        return data;
    }

    @Override
    public Alarm[] getAlarmsForSet(SurveillanceSet set) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class, "alarm");
        OnmsCriteria nodeCriteria = criteria.createCriteria("node");
        this.addCriteriaForSurveillanceSet(nodeCriteria, set);
        nodeCriteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        criteria.addOrder(Order.desc((String)"alarm.severity"));
        criteria.setMaxResults(Integer.valueOf(100));
        List alarms = this.m_alarmDao.findMatching(criteria);
        Alarm[] alarmArray = new Alarm[alarms.size()];
        int index = 0;
        boolean isDashboardRole = this.isDashboardRole();
        for (OnmsAlarm alarm : alarms) {
            alarmArray[index] = new Alarm(alarm.getSeverity().getLabel(), alarm.getNode().getLabel(), alarm.getNode().getId(), isDashboardRole, alarm.getLogMsg(), alarm.getDescription(), alarm.getCounter(), new Date(alarm.getFirstEventTime().getTime()), new Date(alarm.getLastEventTime().getTime()));
            ++index;
        }
        return alarmArray;
    }

    @Override
    public String[] getNodeNames(SurveillanceSet set) {
        List nodes = this.m_nodeDao.findAll();
        ArrayList<String> labels = new ArrayList<String>(nodes.size());
        for (OnmsNode node : nodes) {
            labels.add(node.getLabel());
        }
        return labels.toArray(new String[labels.size()]);
    }

    @Override
    public String[][] getResources(SurveillanceSet set) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class, "node");
        this.addCriteriaForSurveillanceSet(criteria, set);
        criteria.add((Criterion)Restrictions.ne((String)"node.type", (Object)"D"));
        criteria.addOrder(Order.asc((String)"node.label"));
        List nodes = this.m_nodeDao.findMatching(criteria);
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        for (OnmsNode node : nodes) {
            OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
            if (resource == null || resource.getAttributes().size() <= 0 && resource.getChildResources().size() <= 0) continue;
            resources.add(resource);
        }
        ArrayList<String[]> labels = new ArrayList<String[]>(resources.size());
        for (OnmsResource resource : resources) {
            labels.add(new String[]{resource.getId(), resource.getResourceType().getLabel() + ": " + resource.getLabel()});
        }
        return (String[][])labels.toArray((T[])new String[labels.size()][]);
    }

    private void addCriteriaForSurveillanceSet(OnmsCriteria criteria, SurveillanceSet set) {
        CriteriaAddingVisitor visitor = new CriteriaAddingVisitor(criteria);
        visitor.setView(this.getView());
        visitor.setCategoryDao(this.m_categoryDao);
        visitor.afterPropertiesSet();
        set.visit(visitor);
    }

    private View getView() {
        String user = this.getUsername();
        this.log().debug("Looking for surveillance view that matches user '" + user + "'");
        View userView = this.m_surveillanceViewConfigDao.getView(user);
        if (userView != null) {
            this.log().debug("Found surveillance view '" + userView.getName() + "' matching user name '" + user + "'");
            return userView;
        }
        List groups = this.m_groupDao.findGroupsForUser(user);
        for (Group group : groups) {
            View groupView = this.m_surveillanceViewConfigDao.getView(group.getName());
            if (groupView == null) continue;
            this.log().debug("Found surveillance view '" + groupView.getName() + "' matching group '" + group.getName() + "' name for user '" + user + "'");
            return groupView;
        }
        View defaultView = this.m_surveillanceViewConfigDao.getDefaultView();
        if (defaultView == null) {
            String message = "There is no default surveillance view and we could not find a surviellance view for the user's username ('" + user + "') or any of their groups";
            this.log().warn(message);
            throw new ObjectRetrievalFailureException(View.class, (Object)message);
        }
        this.log().debug("Did not find a surveillance view matching the user's user name or one of their group names.  Using the default view for user '" + user + "'");
        return defaultView;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected String getUsername() {
        SecurityContext context = SecurityContextHolder.getContext();
        Assert.state((context != null ? 1 : 0) != 0, (String)"No security context found when calling SecurityContextHolder.getContext()");
        Authentication auth = context.getAuthentication();
        Assert.state((auth != null ? 1 : 0) != 0, (String)"No Authentication object found when calling getAuthentication on our SecurityContext object");
        Object obj = auth.getPrincipal();
        Assert.state((obj != null ? 1 : 0) != 0, (String)"No principal object found when calling getPrincipal on our Authentication object");
        if (obj instanceof UserDetails) {
            return ((UserDetails)obj).getUsername();
        }
        throw new IllegalStateException("principal should always be instanceof UserDetails");
    }

    protected boolean isDashboardRole() {
        boolean isDashboardRole = true;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && !context.toString().contains("ROLE_DASHBOARD")) {
            isDashboardRole = false;
        }
        this.log().debug("User " + this.getUsername() + " is in dashboard role? " + isDashboardRole);
        return isDashboardRole;
    }

    @Override
    public String[][] getChildResources(String id) {
        OnmsResource parentResource = this.m_resourceDao.getResourceById(id);
        if (parentResource == null) {
            return null;
        }
        List resources = parentResource.getChildResources();
        ArrayList<String[]> labels = new ArrayList<String[]>(resources.size());
        for (OnmsResource resource : resources) {
            labels.add(new String[]{resource.getId(), resource.getResourceType().getLabel() + ": " + resource.getLabel()});
        }
        return (String[][])labels.toArray((T[])new String[labels.size()][]);
    }

    @Override
    public String[][] getPrefabGraphs(String id) {
        OnmsResource resource = this.m_resourceDao.getResourceById(id);
        if (resource == null) {
            return null;
        }
        PrefabGraph[] graphs = this.m_graphDao.getPrefabGraphsForResource(resource);
        ArrayList<String[]> labels = new ArrayList<String[]>(graphs.length);
        for (PrefabGraph graph : graphs) {
            labels.add(new String[]{graph.getName(), graph.getName()});
        }
        return (String[][])labels.toArray((T[])new String[labels.size()][]);
    }

    @Override
    public Notification[] getNotificationsForSet(SurveillanceSet set) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Date fifteenMinutesAgo = new Date(System.currentTimeMillis() - 900000L);
        Date oneWeekAgo = new Date(System.currentTimeMillis() - 604800000L);
        notifications.addAll(this.getNotificationsWithCriterion(set, "Critical", new Criterion[]{Restrictions.isNull((String)"notification.respondTime"), Restrictions.le((String)"notification.pageTime", (Object)fifteenMinutesAgo)}));
        notifications.addAll(this.getNotificationsWithCriterion(set, "Minor", new Criterion[]{Restrictions.isNull((String)"notification.respondTime"), Restrictions.gt((String)"notification.pageTime", (Object)fifteenMinutesAgo)}));
        notifications.addAll(this.getNotificationsWithCriterion(set, "Normal", new Criterion[]{Restrictions.isNotNull((String)"notification.respondTime"), Restrictions.gt((String)"notification.pageTime", (Object)oneWeekAgo)}));
        return notifications.toArray(new Notification[notifications.size()]);
    }

    private List<Notification> getNotificationsWithCriterion(SurveillanceSet set, String severity, Criterion ... criterions) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNotification.class, "notification");
        OnmsCriteria nodeCriteria = criteria.createCriteria("node");
        this.addCriteriaForSurveillanceSet(nodeCriteria, set);
        nodeCriteria.add((Criterion)Restrictions.ne((String)"type", (Object)"D"));
        for (Criterion criterion : criterions) {
            criteria.add(criterion);
        }
        criteria.addOrder(Order.desc((String)"notification.pageTime"));
        List notifications = this.m_notificationDao.findMatching(criteria);
        return this.convertOnmsNotificationsToNotifications(notifications, severity);
    }

    private List<Notification> convertOnmsNotificationsToNotifications(List<OnmsNotification> notifications, String severity) {
        ArrayList<Notification> notifs = new ArrayList<Notification>(notifications.size());
        boolean isDashboardRole = this.isDashboardRole();
        for (OnmsNotification notification : notifications) {
            notifs.add(this.createNotification(notification, severity, isDashboardRole));
        }
        return notifs;
    }

    private Notification createNotification(OnmsNotification onmsNotif, String severity, boolean isDashboardRole) {
        Notification notif = new Notification();
        notif.setNodeLabel(onmsNotif.getNode().getLabel());
        notif.setNodeId(onmsNotif.getNode().getNodeId());
        notif.setIsDashboardRole(isDashboardRole);
        notif.setResponder(onmsNotif.getAnsweredBy());
        notif.setRespondTime(onmsNotif.getRespondTime() == null ? null : new Date(onmsNotif.getRespondTime().getTime()));
        notif.setSentTime(onmsNotif.getPageTime() == null ? null : new Date(onmsNotif.getPageTime().getTime()));
        notif.setServiceName(onmsNotif.getServiceType() == null ? "" : onmsNotif.getServiceType().getName());
        notif.setTextMessage(onmsNotif.getTextMsg() == null ? "" : onmsNotif.getTextMsg());
        notif.setSeverity(severity);
        return notif;
    }

    @Override
    public NodeRtc[] getRtcForSet(SurveillanceSet set) {
        OnmsCriteria serviceCriteria = this.m_rtcService.createServiceCriteria();
        OnmsCriteria outageCriteria = this.m_rtcService.createOutageCriteria();
        this.addCriteriaForSurveillanceSet(serviceCriteria, set);
        this.addCriteriaForSurveillanceSet(outageCriteria, set);
        RtcNodeModel model = this.m_rtcService.getNodeListForCriteria(serviceCriteria, outageCriteria);
        NodeRtc[] nodeRtc = new NodeRtc[model.getNodeList().size()];
        int index = 0;
        boolean isDashboardRole = this.isDashboardRole();
        for (RtcNodeModel.RtcNode node : model.getNodeList()) {
            NodeRtc n = new NodeRtc();
            n.setNodeLabel(node.getNode().getLabel());
            n.setNodeId(node.getNode().getNodeId());
            n.setIsDashboardRole(isDashboardRole);
            n.setDownServiceCount(node.getDownServiceCount());
            n.setServiceCount(node.getServiceCount());
            if (node.getDownServiceCount() == 0) {
                n.setServiceStyle("Normal");
            } else {
                n.setServiceStyle("Critical");
            }
            n.setAvailability(node.getAvailabilityAsString());
            if (node.getAvailability() == 1.0) {
                n.setAvailabilityStyle("Normal");
            } else {
                n.setAvailabilityStyle("Critical");
            }
            nodeRtc[index++] = n;
        }
        return nodeRtc;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"nodeDao property must be set and cannot be null");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property must be set and cannot be null");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property must be set and cannot be null");
        Assert.state((this.m_webSurveillanceService != null ? 1 : 0) != 0, (String)"webSurveillanceService property must be set and cannot be null");
        Assert.state((this.m_surveillanceViewConfigDao != null ? 1 : 0) != 0, (String)"surveillanceViewConfigDao property must be set and cannot be null");
        Assert.state((this.m_categoryDao != null ? 1 : 0) != 0, (String)"categoryDao property must be set and cannot be null");
        Assert.state((this.m_alarmDao != null ? 1 : 0) != 0, (String)"alarmDao property must be set and cannot be null");
        Assert.state((this.m_notificationDao != null ? 1 : 0) != 0, (String)"notificationDao property must be set and cannot be null");
        Assert.state((this.m_rtcService != null ? 1 : 0) != 0, (String)"rtcService property must be set and cannot be null");
        Assert.state((this.m_groupDao != null ? 1 : 0) != 0, (String)"groupDao property must be set and cannot be null");
        Assert.state((this.m_outageDao != null ? 1 : 0) != 0, (String)"outageDao property must be set and cannot be null");
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setNotificationDao(NotificationDao notifDao) {
        this.m_notificationDao = notifDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public org.opennms.web.svclayer.SurveillanceService getWebSurveillanceService() {
        return this.m_webSurveillanceService;
    }

    public void setWebSurveillanceService(org.opennms.web.svclayer.SurveillanceService webSurveillanceService) {
        this.m_webSurveillanceService = webSurveillanceService;
    }

    public SurveillanceViewConfigDao getSurveillanceViewConfigDao() {
        return this.m_surveillanceViewConfigDao;
    }

    public void setSurveillanceViewConfigDao(SurveillanceViewConfigDao surveillanceViewConfigDao) {
        this.m_surveillanceViewConfigDao = surveillanceViewConfigDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public RtcService getRtcService() {
        return this.m_rtcService;
    }

    public void setRtcService(RtcService rtcService) {
        this.m_rtcService = rtcService;
    }

    public GroupDao getGroupDao() {
        return this.m_groupDao;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    public OutageDao getOutageDao() {
        return this.m_outageDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }
}

