/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DashletView;
import org.opennms.dashboard.client.Pageable;
import org.opennms.dashboard.client.Pager;

public abstract class PageableTableView
extends DashletView
implements Pageable {
    private VerticalPanel m_panel = new VerticalPanel();
    private FlexTable m_table = new FlexTable();
    private Pager m_pager;
    private String[] m_headings;
    private int m_pageSize = 5;
    private int m_currentIndex = 0;

    PageableTableView(Dashlet dashlet, int pageSize, String[] headings) {
        super(dashlet);
        this.m_pageSize = pageSize;
        this.initializeTable(headings);
        this.m_pager = new Pager(this);
        this.m_panel.add((Widget)this.m_table);
        this.initWidget((Widget)this.m_panel);
    }

    @Override
    public void onDashLoad() {
        this.addToTitleBar((Widget)this.m_pager, DockPanel.CENTER);
    }

    protected abstract void setRow(FlexTable var1, int var2, int var3);

    @Override
    public abstract int getElementCount();

    protected void initializeTable(String[] headings) {
        this.setHeadings(headings);
        for (int i = 1; i <= this.getPageSize(); ++i) {
            this.clearRow(i);
        }
    }

    private void setHeadings(String[] headings) {
        this.m_headings = headings;
        for (int i = 0; i < headings.length; ++i) {
            this.m_table.setText(0, i, headings[i]);
        }
        this.m_table.getRowFormatter().setStyleName(0, "header");
    }

    private int getColumnCount() {
        return this.m_headings == null ? 0 : this.m_headings.length;
    }

    private void clearRow(int row) {
        if (row >= this.m_table.getRowCount()) {
            return;
        }
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.m_table.clearCell(row, column);
        }
        String currStyle = this.m_table.getRowFormatter().getStyleName(row);
        if (currStyle != null) {
            this.m_table.getRowFormatter().removeStyleName(row, currStyle);
        }
        this.formatCells(this.m_table, row);
    }

    protected void refresh() {
        int i;
        int rows = Math.min(this.m_currentIndex + this.getPageSize(), this.getElementCount());
        for (i = this.m_currentIndex + 1; i <= rows; ++i) {
            this.setRow(this.m_table, i - this.m_currentIndex, i - 1);
            this.formatCells(this.m_table, i - this.m_currentIndex);
        }
        for (i = rows + 1; i <= this.m_currentIndex + this.getPageSize(); ++i) {
            this.clearRow(i - this.m_currentIndex);
        }
        this.m_pager.update();
    }

    protected void formatCells(FlexTable table, int row) {
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.m_table.getCellFormatter().setStyleName(row, column, "divider");
        }
    }

    @Override
    public int getCurrentElement() {
        return this.m_currentIndex;
    }

    @Override
    public int getPageSize() {
        return this.m_pageSize;
    }

    public void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    @Override
    public void setCurrentElement(int element) {
        this.m_currentIndex = element;
        this.refresh();
    }
}

