/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;

public class UserRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Test
    public void testUser() throws Exception {
        String url = "/users";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("admin"));
        OnmsUserList list = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getUsers().size());
        Assert.assertEquals((String)xml, (Object)"admin", (Object)((OnmsUser)list.getUsers().get(0)).getUsername());
        xml = this.sendRequest(GET, url + "/admin", 200);
        Assert.assertTrue((boolean)xml.contains(">admin<"));
        this.sendRequest(GET, url + "/idontexist", 404);
    }

    @Test
    public void testWriteUser() throws Exception {
        this.createUser("test");
        String xml = this.sendRequest(GET, "/users/test", 200);
        Assert.assertTrue((boolean)xml.contains("<user><user-id>test</user-id>"));
        this.sendPut("/users/test", "password=MONKEYS", 303, "/users/test");
        xml = this.sendRequest(GET, "/users/test", 200);
        Assert.assertTrue((boolean)xml.contains(">MONKEYS<"));
    }

    @Test
    public void testWriteALotOfUsers() throws Exception {
        int userCount = 40;
        ExecutorService pool = Executors.newCachedThreadPool();
        ArrayList<Future<Object>> createFutures = new ArrayList<Future<Object>>();
        for (int i = 0; i < userCount; ++i) {
            final String string = "test" + i;
            createFutures.add(pool.submit(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    try {
                        UserRestServiceTest.this.createUser(string);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            })));
        }
        for (Future future : createFutures) {
            future.get();
        }
        this.sendRequest(GET, "/users", 200);
        for (int i = 0; i < userCount; ++i) {
            String string = this.sendRequest(GET, "/users/test" + i, 200);
            Assert.assertTrue((boolean)string.contains(String.format("<user><user-id>test%d</user-id>", i)));
            this.sendPut("/users/test" + i, "password=MONKEYS", 303, "/users/test" + i);
            String string2 = this.sendRequest(GET, "/users/test" + i, 200);
            Assert.assertTrue((boolean)string2.contains(">MONKEYS<"));
        }
    }

    @Test
    public void testDeleteUser() throws Exception {
        this.createUser("deleteMe");
        String xml = this.sendRequest(GET, "/users", 200);
        Assert.assertTrue((boolean)xml.contains("deleteMe"));
        this.sendRequest(DELETE, "/users/idontexist", 400);
        this.sendRequest(DELETE, "/users/deleteMe", 200);
        this.sendRequest(GET, "/users/deleteMe", 404);
    }

    protected void createUser(String username) throws Exception {
        String user = "<user><user-id>" + username + "</user-id>" + "<full-name>" + username + " Full Name</full-name>" + "<user-comments>Autogenerated by a unit test...</user-comments>" + "<password>21232F297A57A5A743894A0E4A801FC3</password>" + "</user>";
        this.sendPost("/users", user, 303, "/users/" + username);
    }
}

