/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.web.snmpinfo.SnmpInfo;

public class SnmpConfigRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    JAXBContext m_jaxbContext;
    private File m_snmpConfigFile;

    @Override
    protected void beforeServletStart() throws Exception {
        File dir = new File("target/test-work-dir");
        dir.mkdirs();
        this.m_snmpConfigFile = File.createTempFile("snmp-config-", "xml");
        FileUtils.writeStringToFile((File)this.m_snmpConfigFile, (String)"<?xml version=\"1.0\"?><snmp-config port=\"9161\" retry=\"1\" timeout=\"2000\"\n             read-community=\"myPublic\" \n             version=\"v1\" \n             max-vars-per-pdu=\"100\"  />");
        SnmpPeerFactory.setFile((File)this.m_snmpConfigFile);
        this.m_jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SnmpInfo.class});
    }

    @Test
    public void testGetForUnknownIp() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        SnmpInfo config = this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        this.assertConfiguration(config, 9161, 1, 2000, "myPublic", "v1");
    }

    @Test
    public void testSetNewValue() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        SnmpInfo config = this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        this.assertConfiguration(config, 9161, 1, 2000, "myPublic", "v1");
        config.setVersion("v2c");
        config.setTimeout(1000);
        config.setCommunity("new");
        this.putXmlObject(this.m_jaxbContext, url, 303, config, "/snmpConfig/1.1.1.1");
        SnmpInfo newConfig = this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        this.assertConfiguration(newConfig, 9161, 1, 1000, "new", "v2c");
        this.dumpConfig();
    }

    private void dumpConfig() throws Exception {
        IOUtils.copy((InputStream)new FileInputStream(this.m_snmpConfigFile), (OutputStream)System.out);
    }

    private void assertConfiguration(SnmpInfo config, int port, int retries, int timeout, String commString, String version) {
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)port, (long)config.getPort());
        Assert.assertEquals((long)retries, (long)config.getRetries());
        Assert.assertEquals((long)timeout, (long)config.getTimeout());
        Assert.assertEquals((Object)commString, (Object)config.getCommunity());
        Assert.assertEquals((Object)version, (Object)config.getVersion());
    }
}

