/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AcknowledgmentRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Override
    protected void afterServletStart() {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        DatabasePopulator dbp = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        dbp.populateDatabase();
    }

    @Test
    public void testAcknowlegeNotification() throws Exception {
        Pattern p = Pattern.compile("^.*<answeredBy>(.*?)</answeredBy>.*$", 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "notifId=1&action=ack");
        String xml = this.sendRequest(GET, "/notifications/1", new HashMap(), 200);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.group(1).equals("admin"));
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "notifId=1&action=unack");
        xml = this.sendRequest(GET, "/notifications/1", new HashMap(), 200);
        m = p.matcher(xml);
        Assert.assertFalse((boolean)m.matches());
    }

    @Test
    public void testAcknowlegeAlarm() throws Exception {
        Pattern p = Pattern.compile("^.*<ackTime>(.*?)</ackTime>.*$", 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=ack");
        String xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((m.group(1).length() > 0 ? 1 : 0) != 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=unack");
        xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        m = p.matcher(xml);
        Assert.assertFalse((boolean)m.matches());
    }
}

