/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.server;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.dashboard.client.NodeRtc;
import org.opennms.dashboard.client.SurveillanceSet;
import org.opennms.dashboard.server.DefaultSurveillanceService;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.surveillanceViews.Columns;
import org.opennms.netmgt.config.surveillanceViews.Rows;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.web.svclayer.RtcService;
import org.opennms.web.svclayer.support.DefaultRtcService;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class DefaultSurveillanceServiceTest {
    private DefaultSurveillanceService m_service;

    @Before
    public void setUp() throws Exception {
        this.m_service = new DefaultSurveillanceService();
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testGetUsernameWithUserDetails() {
        UserDetails details = this.populateSecurityContext();
        String user = this.m_service.getUsername();
        Assert.assertNotNull((String)"user should not be null", (Object)user);
        Assert.assertEquals((String)"user name", (Object)details.getUsername(), (Object)user);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetUsernameWithStringPrincipal() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", null, new ArrayList());
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        String user = this.m_service.getUsername();
    }

    @Test
    public void testGetUsernameNoAuthenticationObject() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("No Authentication object found when calling getAuthentication on our SecurityContext object"));
        try {
            this.m_service.getUsername();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testGetUsernameNoPrincipalObject() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(null, null, new ArrayList());
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("No principal object found when calling getPrincipal on our Authentication object"));
        try {
            this.m_service.getUsername();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testGetRtcForSet() {
        UserDetails details = this.populateSecurityContext();
        EasyMockUtils mock = new EasyMockUtils();
        MonitoredServiceDao monSvcDao = (MonitoredServiceDao)mock.createMock(MonitoredServiceDao.class);
        OutageDao outageDao = (OutageDao)mock.createMock(OutageDao.class);
        SurveillanceViewConfigDao survViewConfigDao = (SurveillanceViewConfigDao)mock.createMock(SurveillanceViewConfigDao.class);
        GroupDao groupDao = (GroupDao)mock.createMock(GroupDao.class);
        CategoryDao categoryDao = (CategoryDao)mock.createMock(CategoryDao.class);
        mock.replayAll();
        DefaultRtcService rtcService = new DefaultRtcService();
        rtcService.setMonitoredServiceDao(monSvcDao);
        rtcService.setOutageDao(outageDao);
        rtcService.afterPropertiesSet();
        this.m_service.setRtcService((RtcService)rtcService);
        this.m_service.setSurveillanceViewConfigDao(survViewConfigDao);
        this.m_service.setGroupDao(groupDao);
        this.m_service.setCategoryDao(categoryDao);
        mock.verifyAll();
        EasyMock.expect((Object)survViewConfigDao.getView(details.getUsername())).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)groupDao.findGroupsForUser(details.getUsername())).andReturn(new ArrayList()).atLeastOnce();
        View defaultView = new View();
        defaultView.setColumns(new Columns());
        defaultView.setRows(new Rows());
        EasyMock.expect((Object)survViewConfigDao.getDefaultView()).andReturn((Object)defaultView).atLeastOnce();
        EasyMock.expect((Object)monSvcDao.findMatching((OnmsCriteria)EasyMock.isA(OnmsCriteria.class))).andReturn(new ArrayList());
        EasyMock.expect((Object)outageDao.findMatching((OnmsCriteria)EasyMock.isA(OnmsCriteria.class))).andReturn(new ArrayList());
        mock.replayAll();
        NodeRtc[] rtcs = this.m_service.getRtcForSet(SurveillanceSet.DEFAULT);
        mock.verifyAll();
        Assert.assertNotNull((String)"rtcs should not be null", (Object)rtcs);
    }

    private UserDetails populateSecurityContext() {
        User details = new User("user", "password", true, true, true, true, new ArrayList());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)details, null, details.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        return details;
    }
}

