/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.vulnerability.filter.Filter;

public class SeverityFilter
implements Filter {
    public static final String TYPE = "severity";
    protected int severity;

    public SeverityFilter(int severity) {
        this.severity = severity;
    }

    public SeverityFilter(OnmsSeverity severity) {
        this(severity.getId());
    }

    @Override
    public String getSql() {
        return " SEVERITY=" + this.severity;
    }

    @Override
    public String getParamSql() {
        return " SEVERITY=?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.severity);
        return 1;
    }

    @Override
    public String getDescription() {
        return "severity=" + this.severity;
    }

    @Override
    public String getTextDescription() {
        return "severity is " + OnmsSeverity.get((int)new Integer(this.severity)).getLabel();
    }

    public String toString() {
        return "<Vulnerability Severity Filter: " + this.getDescription() + ">";
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

