/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.opennms.web.vulnerability.filter.Filter;

public class ResolvedDateBeforeFilter
implements Filter {
    public static final String TYPE = "resolvedbefore";
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 2);
    protected Date date;

    public ResolvedDateBeforeFilter(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.date = date;
    }

    public ResolvedDateBeforeFilter(long epochTime) {
        this(new Date(epochTime));
    }

    @Override
    public String getSql() {
        return " resolvedTime < to_timestamp('" + this.date.toString() + "'," + "'Dy Mon DD HH24:MI:SS Tz YYYY'" + ")";
    }

    @Override
    public String getParamSql() {
        return " resolvedTime < ?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setTimestamp(parameterIndex, new Timestamp(this.date.getTime()));
        return 1;
    }

    @Override
    public String getDescription() {
        return "resolvedbefore=" + this.date.getTime();
    }

    @Override
    public String getTextDescription() {
        return "resolved time before \"" + DATE_FORMAT.format(this.date) + "\"";
    }

    public String toString() {
        return "<Vulnerability Resolved Date Before Filter: " + this.getDescription() + ">";
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

