/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class ProtocolFilter
implements Filter {
    public static final String TYPE = "protocol";
    protected String protocol;

    public ProtocolFilter(String protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.protocol = protocol;
    }

    @Override
    public String getSql() {
        return " PROTOCOL='" + this.protocol + "'";
    }

    @Override
    public String getParamSql() {
        return " PROTOCOL=?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.protocol);
        return 1;
    }

    @Override
    public String getDescription() {
        return "protocol=" + this.protocol;
    }

    @Override
    public String getTextDescription() {
        return "protocol is " + this.protocol;
    }

    public String toString() {
        return "<Vulnerability Protocol Filter: " + this.getDescription() + ">";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

