/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class NodeNameLikeFilter
implements Filter {
    public static final String TYPE = "nodenamelike";
    protected String substring;

    public NodeNameLikeFilter(String substring) {
        if (substring == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.substring = substring;
    }

    @Override
    public String getSql() {
        return " VULNERABILITYID IN (SELECT VULNERABILITYID FROM VULNERABILITIES JOIN NODE ON VULNERABILITIES.NODEID=NODE.NODEID WHERE UPPER(NODE.NODELABEL) LIKE '%" + this.substring.toUpperCase() + "%')";
    }

    @Override
    public String getParamSql() {
        return " VULNERABILITYID IN (SELECT VULNERABILITYID FROM VULNERABILITIES JOIN NODE ON (VULNERABILITIES.NODEID=NODE.NODEID) WHERE UPPER(NODE.NODELABEL) LIKE ?)";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.substring.toUpperCase());
        return 1;
    }

    @Override
    public String getDescription() {
        return "nodenamelike=" + this.substring;
    }

    @Override
    public String getTextDescription() {
        return "node name contains \"" + this.substring + "\"";
    }

    public String toString() {
        return "<Vulnerability Node Name Containing Filter: " + this.getDescription() + ">";
    }

    public String getSubstring() {
        return this.substring;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

