/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class NegativePortFilter
implements Filter {
    public static final String TYPE = "portnot";
    protected int port;

    public NegativePortFilter(int port) {
        this.port = port;
    }

    @Override
    public String getSql() {
        return " PORT<>" + this.port;
    }

    @Override
    public String getParamSql() {
        return " PORT<>?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setInt(parameterIndex, this.port);
        return 1;
    }

    @Override
    public String getDescription() {
        return "portnot=" + this.port;
    }

    @Override
    public String getTextDescription() {
        return "port is not " + this.port;
    }

    public String toString() {
        return "<Vulnerability Negative Port Filter: " + this.getDescription() + ">";
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

