/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.vulnerability.Vulnerability;
import org.opennms.web.vulnerability.VulnerabilityFactory;
import org.opennms.web.vulnerability.VulnerabilityQueryParms;
import org.opennms.web.vulnerability.VulnerabilityUtil;
import org.opennms.web.vulnerability.filter.Filter;

public class VulnerabilityFilterServlet
extends HttpServlet {
    private static final long serialVersionUID = -1885837409842764000L;
    public static final int DEFAULT_LIMIT = 10;
    public static final int DEFAULT_MULTIPLE = 0;
    public static final VulnerabilityFactory.SortStyle DEFAULT_SORT_STYLE = VulnerabilityFactory.SortStyle.ID;
    public static final VulnerabilityFactory.ResolutionType DEFAULT_RESOLUTION_TYPE = VulnerabilityFactory.ResolutionType.BOTH;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        VulnerabilityFactory.ResolutionType temp;
        VulnerabilityFactory.SortStyle temp2;
        String sortStyleString = request.getParameter("sortby");
        VulnerabilityFactory.SortStyle sortStyle = DEFAULT_SORT_STYLE;
        if (sortStyleString != null && (temp2 = VulnerabilityUtil.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp2;
        }
        String resTypeString = request.getParameter("restype");
        VulnerabilityFactory.ResolutionType resType = DEFAULT_RESOLUTION_TYPE;
        if (resTypeString != null && (temp = VulnerabilityUtil.getResolutionType(resTypeString)) != null) {
            resType = temp;
        }
        String[] filterStrings = request.getParameterValues("filter");
        ArrayList<Filter> filterArray = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (int i = 0; i < filterStrings.length; ++i) {
                Filter filter = VulnerabilityUtil.getFilter(filterStrings[i], this.getServletContext());
                if (filter == null) continue;
                filterArray.add(filter);
            }
        }
        String limitString = request.getParameter("limit");
        int limit = 10;
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String multipleString = request.getParameter("multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            VulnerabilityQueryParms parms = new VulnerabilityQueryParms();
            parms.sortStyle = sortStyle;
            parms.resType = resType;
            parms.filters = filterArray;
            parms.limit = limit;
            parms.multiple = multiple;
            Vulnerability[] vuls = VulnerabilityFactory.getVulnerabilities(sortStyle, resType, parms.getFilters(), limit, multiple * limit);
            request.setAttribute("vuls", (Object)vuls);
            request.setAttribute("parms", (Object)parms);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/vulnerability/list.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            throw new ServletException("", (Throwable)e);
        }
    }
}

