/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.StatisticsReport;
import org.opennms.web.controller.statisticsReports.PrettyOnmsResource;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;

public class StatisticsReportModel {
    private BindException m_errors;
    private StatisticsReport m_report;
    private SortedSet<Datum> m_data = new TreeSet<Datum>();

    public SortedSet<Datum> getData() {
        return this.m_data;
    }

    public void setData(SortedSet<Datum> data) {
        this.m_data = data;
    }

    public void addData(Datum datum) {
        this.m_data.add(datum);
    }

    public BindException getErrors() {
        return this.m_errors;
    }

    public void setErrors(BindException errors) {
        this.m_errors = errors;
    }

    public StatisticsReport getReport() {
        return this.m_report;
    }

    public void setReport(StatisticsReport report) {
        this.m_report = report;
    }

    public static class Datum
    implements Comparable<Datum> {
        private Double m_value;
        private OnmsResource m_resource;

        @Override
        public int compareTo(Datum o) {
            return this.m_value.compareTo(o.getValue());
        }

        public OnmsResource getResource() {
            return this.m_resource;
        }

        public OnmsResource getPrettyResource() {
            return new PrettyOnmsResource(this.m_resource);
        }

        public void setResource(OnmsResource resource) {
            this.m_resource = resource;
        }

        public String getResourceParentLabel() {
            Assert.notNull((Object)this.m_resource, (String)"the resource must be set before calling this method");
            StringBuffer buffer = new StringBuffer();
            for (OnmsResource parent = this.m_resource.getParent(); parent != null; parent = parent.getParent()) {
                if (buffer.length() > 0) {
                    buffer.append("<br/>");
                }
                buffer.append(parent.getResourceType().getLabel());
                buffer.append(": ");
                buffer.append(parent.getLabel());
            }
            return buffer.toString();
        }

        public List<OnmsResource> getResourceParentsReversed() {
            if (this.m_resource == null) {
                return new ArrayList<OnmsResource>(0);
            }
            ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
            for (OnmsResource parent = this.m_resource.getParent(); parent != null; parent = parent.getParent()) {
                resources.add(0, parent);
            }
            return resources;
        }

        public List<OnmsResource> getPrettyResourceParentsReversed() {
            if (this.m_resource == null) {
                return new ArrayList<OnmsResource>(0);
            }
            ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
            for (PrettyOnmsResource parent = new PrettyOnmsResource(this.m_resource.getParent()); parent != null; parent = parent.getParent()) {
                resources.add(0, new PrettyOnmsResource(parent));
            }
            return resources;
        }

        public Double getValue() {
            return this.m_value;
        }

        public void setValue(Double value) {
            this.m_value = value;
        }
    }
}

