/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.config.attrsummary.Attribute;
import org.opennms.netmgt.config.attrsummary.Resource;
import org.opennms.netmgt.config.attrsummary.Summary;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.web.svclayer.RrdSummaryService;
import org.opennms.web.svclayer.SummarySpecification;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultRrdSummaryService
implements RrdSummaryService,
InitializingBean {
    public FilterDao m_filterDao;
    public ResourceDao m_resourceDao;
    public RrdDao m_rrdDao;
    public Stats m_stats = new Stats();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Summary getSummary(String filterRule, final long startTime, final long endTime, final String attributeSieve) {
        this.m_stats.begin("getSummary");
        try {
            final SummaryBuilder bldr = new SummaryBuilder();
            this.m_filterDao.walkMatchingNodes(filterRule, (EntityVisitor)new AbstractEntityVisitor(){

                public void visitNode(OnmsNode node) {
                    OnmsResource nodeResource = this.getResourceForNode(node);
                    bldr.pushResource(node.getLabel());
                    for (OnmsResource child : this.getChildResources1(nodeResource)) {
                        if (!(child.getResourceType() instanceof NodeSnmpResourceType)) continue;
                        this.addAttributes(this.getResourceGraphAttributes(child));
                    }
                    for (OnmsResource child : this.getChildResources2(nodeResource)) {
                        if (child.getResourceType() instanceof NodeSnmpResourceType) continue;
                        this.addResource(child);
                    }
                    bldr.popResource();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Collection<RrdGraphAttribute> getResourceGraphAttributes(OnmsResource child) {
                    String op = "getResourceGraphAttributes-" + child.getResourceType().getName();
                    DefaultRrdSummaryService.this.m_stats.begin(op);
                    try {
                        Collection<RrdGraphAttribute> collection = child.getRrdGraphAttributes().values();
                        return collection;
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end(op);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private List<OnmsResource> getChildResources1(OnmsResource nodeResource) {
                    DefaultRrdSummaryService.this.m_stats.begin("getChildResources1");
                    try {
                        List list = nodeResource.getChildResources();
                        return list;
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end("getChildResources1");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private List<OnmsResource> getChildResources2(OnmsResource nodeResource) {
                    DefaultRrdSummaryService.this.m_stats.begin("getChildResources2");
                    try {
                        List list = nodeResource.getChildResources();
                        return list;
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end("getChildResources2");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private OnmsResource getResourceForNode(OnmsNode node) {
                    DefaultRrdSummaryService.this.m_stats.begin("getResourceForNode");
                    try {
                        OnmsResource onmsResource = DefaultRrdSummaryService.this.m_resourceDao.getResourceForNode(node);
                        return onmsResource;
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end("getResourceForNode");
                    }
                }

                private void addResource(OnmsResource resource) {
                    this.addResource(resource, resource.getLabel());
                }

                private void addResource(OnmsResource resource, String label) {
                    Collection<RrdGraphAttribute> attrs = this.getResourceGraphAttributes(resource);
                    if (attrs.size() > 0) {
                        bldr.pushResource(label);
                        this.addAttributes(attrs);
                        bldr.popResource();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void addAttributes(Collection<RrdGraphAttribute> attrs) {
                    DefaultRrdSummaryService.this.m_stats.begin("addAttributes");
                    try {
                        for (RrdGraphAttribute attr : attrs) {
                            if (!attr.getName().matches(attributeSieve)) continue;
                            bldr.addAttribute(attr.getName());
                            double[] values = this.getValues(attr);
                            bldr.setMin(values[0]);
                            bldr.setAverage(values[1]);
                            bldr.setMax(values[2]);
                        }
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end("addAttributes");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private double[] getValues(RrdGraphAttribute attr) {
                    DefaultRrdSummaryService.this.m_stats.begin("getValues");
                    try {
                        double[] dArray = DefaultRrdSummaryService.this.m_rrdDao.getPrintValues((OnmsAttribute)attr, "AVERAGE", startTime * 1000L, endTime * 1000L, new String[]{"MIN", "AVERAGE", "MAX"});
                        return dArray;
                    }
                    finally {
                        DefaultRrdSummaryService.this.m_stats.end("getValues");
                    }
                }
            });
            Summary summary = bldr.getSummary();
            return summary;
        }
        finally {
            this.m_stats.end("getSummary");
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"filterDao property must be set");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property must be set");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"rrdDao property must be set");
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    @Override
    public Summary getSummary(SummarySpecification spec) {
        return this.getSummary(spec.getFilterRule(), spec.getStartTime(), spec.getEndTime(), spec.getAttributeSieve());
    }

    static class Stats {
        Map<String, OpStats> map = new LinkedHashMap<String, OpStats>();

        Stats() {
        }

        public void begin(String operation) {
            if (!this.map.containsKey(operation)) {
                this.map.put(operation, new OpStats(operation));
            }
            this.map.get(operation).begin();
        }

        public void end(String operation) {
            this.map.get(operation).end();
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder(this.map.size() * 50);
            for (OpStats opStat : this.map.values()) {
                bldr.append(opStat);
                bldr.append('\n');
            }
            return bldr.toString();
        }
    }

    static class OpStats {
        private String m_name;
        private int m_count = 0;
        private long m_total = 0L;
        private long m_lastStarted = -1L;

        OpStats(String n) {
            this.m_name = n;
        }

        void begin() {
            ++this.m_count;
            this.m_lastStarted = System.nanoTime();
        }

        void end() {
            long ended = System.nanoTime();
            Assert.state((this.m_lastStarted >= 0L ? 1 : 0) != 0, (String)"must call begin before calling end");
            this.m_total += ended - this.m_lastStarted;
            this.m_lastStarted = -1L;
        }

        public String toString() {
            double total = this.m_total;
            return String.format("stats: %s: count=%d, totalTime=%f ms ( %f us/call )", this.m_name, this.m_count, total / 1000000.0, total / ((double)this.m_count * 1000.0));
        }
    }

    static class SummaryBuilder {
        private SummaryHolder m_root = new SummaryHolder();
        private ResourceHolder m_currentResource;
        private Attribute m_currAttr;

        SummaryBuilder() {
        }

        Summary getSummary() {
            return this.m_root.getSummary();
        }

        public void addAttribute(String name) {
            Assert.state((this.m_currentResource != null ? 1 : 0) != 0, (String)"addResource must be called before calling addAttribute");
            this.m_currAttr = this.m_currentResource.addAttribute(name);
        }

        public void setMin(double min) {
            this.checkForCurrAttr();
            this.m_currAttr.setMin(min);
        }

        private void checkForCurrAttr() {
            Assert.state((this.m_currAttr != null ? 1 : 0) != 0, (String)"addAttribute must be called before calling setMin,setMax or setAverage");
        }

        public void setAverage(double avg) {
            this.checkForCurrAttr();
            this.m_currAttr.setAverage(avg);
        }

        public void setMax(double max) {
            this.checkForCurrAttr();
            this.m_currAttr.setMax(max);
        }

        public void pushResource(String label) {
            ResourceParent parent = this.m_currentResource == null ? this.m_root : this.m_currentResource;
            this.m_currentResource = new ResourceHolder(parent, label);
        }

        public void popResource() {
            Assert.state((this.m_currentResource != null ? 1 : 0) != 0, (String)"you must push a resource before you can pop one");
            this.m_currentResource = this.m_currentResource.getParent().isRoot() ? null : (ResourceHolder)this.m_currentResource.getParent();
        }

        class ResourceHolder
        implements ResourceParent {
            ResourceParent m_parent;
            boolean m_commited = false;
            Resource m_resource;

            ResourceHolder(ResourceParent parent, String name) {
                Assert.notNull((Object)parent, (String)"parent must not be null");
                this.m_parent = parent;
                this.m_resource = new Resource();
                this.m_resource.setName(name);
            }

            public ResourceParent getParent() {
                return this.m_parent;
            }

            public boolean isCommited() {
                return this.m_commited;
            }

            @Override
            public void commit() {
                if (this.isCommited()) {
                    return;
                }
                if (this.m_parent != null) {
                    this.m_parent.commit();
                }
                this.addSelf();
                this.m_commited = true;
            }

            @Override
            public void addResource(Resource resource) {
                this.m_resource.addResource(resource);
            }

            protected Attribute addAttribute(String name) {
                Attribute attr = new Attribute();
                attr.setName(name);
                this.m_resource.addAttribute(attr);
                this.commit();
                return attr;
            }

            protected void addSelf() {
                if (this.getParent() == null) {
                    SummaryBuilder.this.m_root.addResource(this.m_resource);
                } else {
                    this.getParent().addResource(this.m_resource);
                }
            }

            public String toString() {
                return (this.getParent() == null ? "[root]" : this.getParent().toString()) + ".[" + this.m_resource.getName() + "]";
            }

            @Override
            public boolean isRoot() {
                return false;
            }
        }

        class SummaryHolder
        implements ResourceParent {
            Summary m_summary = new Summary();

            SummaryHolder() {
            }

            @Override
            public void addResource(Resource resource) {
                this.m_summary.addResource(resource);
            }

            @Override
            public void commit() {
            }

            public Summary getSummary() {
                return this.m_summary;
            }

            @Override
            public boolean isRoot() {
                return true;
            }

            public String toString() {
                return "[root]";
            }
        }

        static interface ResourceParent {
            public boolean isRoot();

            public void addResource(Resource var1);

            public void commit();
        }
    }
}

