/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.web.graph.Graph;
import org.opennms.web.svclayer.RrdGraphService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultRrdGraphService
implements RrdGraphService,
InitializingBean {
    private static final String s_rrdError = "/images/rrd/error.png";
    private GraphDao m_graphDao;
    private ResourceDao m_resourceDao;
    private RrdDao m_rrdDao;

    @Override
    public InputStream getAdhocGraph(String resourceId, String title, String[] dataSources, String[] aggregateFunctions, String[] colors, String[] dataSourceTitles, String[] styles, long start, long end) {
        Assert.notNull((Object)resourceId, (String)"resourceId argument cannot be null");
        Assert.notNull((Object)title, (String)"title argument cannot be null");
        Assert.notNull((Object)dataSources, (String)"dataSources argument cannot be null");
        Assert.notNull((Object)aggregateFunctions, (String)"aggregateFunctions argument cannot be null");
        Assert.notNull((Object)colors, (String)"colors argument cannot be null");
        Assert.notNull((Object)dataSourceTitles, (String)"dataSourceTitles argument cannot be null");
        Assert.notNull((Object)styles, (String)"styles argument cannot be null");
        Assert.isTrue((end > start ? 1 : 0) != 0, (String)"end time must be after start time");
        AdhocGraphType t = this.m_graphDao.findAdhocGraphTypeByName("performance");
        OnmsResource r = this.m_resourceDao.getResourceById(resourceId);
        Assert.notNull((Object)r, (String)("resource \"" + resourceId + "\" could not be located"));
        String command = this.createAdHocCommand(t, r, start, end, title, dataSources, aggregateFunctions, colors, dataSourceTitles, styles);
        return this.getInputStreamForCommand(command);
    }

    private InputStream getInputStreamForCommand(String command) {
        boolean debug = true;
        File workDir = this.m_resourceDao.getRrdDirectory(true);
        InputStream tempIn = null;
        try {
            LogUtils.debugf((Object)this, (String)"Executing RRD command in directory '%s': %s", (Object[])new Object[]{workDir, command});
            tempIn = this.m_rrdDao.createGraph(command, workDir);
        }
        catch (DataAccessException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Exception while creating graph.", (Object[])new Object[0]);
            if (debug) {
                throw e;
            }
            return this.returnErrorImage(s_rrdError);
        }
        return tempIn;
    }

    public InputStream returnErrorImage(String file) {
        InputStream is = this.getClass().getResourceAsStream(file);
        if (is == null) {
            throw new ObjectRetrievalFailureException(InputStream.class, (Object)file, "Could not find error image for '" + file + "' or could open", null);
        }
        return is;
    }

    @Override
    public InputStream getPrefabGraph(String resourceId, String report, long start, long end) {
        Assert.notNull((Object)resourceId, (String)"resourceId argument cannot be null");
        Assert.notNull((Object)report, (String)"report argument cannot be null");
        Assert.isTrue((end > start ? 1 : 0) != 0, (String)("end time " + end + " must be after start time" + start));
        PrefabGraphType t = this.m_graphDao.findPrefabGraphTypeByName("performance");
        if (t == null) {
            throw new IllegalArgumentException("graph type \"performance\" is not valid");
        }
        OnmsResource r = this.m_resourceDao.getResourceById(resourceId);
        Assert.notNull((Object)r, (String)"resource could not be located");
        PrefabGraph prefabGraph = this.m_graphDao.getPrefabGraph(report);
        Graph graph = new Graph(prefabGraph, r, new Date(start), new Date(end));
        String command = this.createPrefabCommand(graph, t.getCommandPrefix(), this.m_resourceDao.getRrdDirectory(true), report);
        return this.getInputStreamForCommand(command);
    }

    protected String createAdHocCommand(AdhocGraphType adhocType, OnmsResource resource, long start, long end, String graphtitle, String[] dsNames, String[] dsAggregFxns, String[] colors, String[] dsTitles, String[] dsStyles) {
        String commandPrefix = adhocType.getCommandPrefix();
        String title = adhocType.getTitleTemplate();
        String ds = adhocType.getDataSourceTemplate();
        String graphline = adhocType.getGraphLineTemplate();
        String starttime = Long.toString(start / 1000L);
        String endtime = Long.toString(end / 1000L);
        StringBuffer buf = new StringBuffer();
        buf.append(commandPrefix);
        buf.append(" ");
        buf.append(title);
        String[] rrdFiles = DefaultRrdGraphService.getRrdNames(resource, dsNames);
        ArrayList<String> defs = new ArrayList<String>(dsNames.length);
        ArrayList<String> lines = new ArrayList<String>(dsNames.length);
        for (int i = 0; i < dsNames.length; ++i) {
            String dsAbbrev = "ds" + Integer.toString(i);
            String dsName = dsNames[i];
            String rrd = rrdFiles[i];
            String dsAggregFxn = dsAggregFxns[i];
            String color = colors[i];
            String dsTitle = dsTitles[i];
            String dsStyle = dsStyles[i];
            defs.add(MessageFormat.format(ds, rrd, starttime, endtime, graphtitle, dsAbbrev, dsName, dsAggregFxn, dsStyle, color, dsTitle));
            lines.add(MessageFormat.format(graphline, rrd, starttime, endtime, graphtitle, dsAbbrev, dsName, dsAggregFxn, dsStyle, color, dsTitle));
        }
        for (String def : defs) {
            buf.append(" ");
            buf.append(def);
        }
        for (String line : lines) {
            buf.append(" ");
            buf.append(line);
        }
        LogUtils.debugf((Object)this, (String)"formatting: %s, bogus-rrd, %s, %s, %s", (Object[])new Object[]{buf, starttime, endtime, graphtitle});
        return MessageFormat.format(buf.toString(), "bogus-rrd", starttime, endtime, graphtitle);
    }

    private static String[] getRrdNames(OnmsResource resource, String[] dsNames) {
        String[] rrds = new String[dsNames.length];
        Map attributes = resource.getRrdGraphAttributes();
        for (int i = 0; i < dsNames.length; ++i) {
            RrdGraphAttribute attribute = (RrdGraphAttribute)attributes.get(dsNames[i]);
            if (attribute == null) {
                throw new IllegalArgumentException("RRD attribute '" + dsNames[i] + "' is not available on resource '" + resource.getId() + "'.  Available RRD attributes: " + StringUtils.collectionToDelimitedString(attributes.keySet(), (String)", "));
            }
            rrds[i] = RrdFileConstants.escapeForGraphing((String)attribute.getRrdRelativePath());
        }
        return rrds;
    }

    private static Map<String, String> getTranslationsForAttributes(Map<String, String> attributes, String[] requiredAttributes, String type) {
        if (requiredAttributes == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> translations = new HashMap<String, String>(requiredAttributes.length);
        for (String requiredAttribute : requiredAttributes) {
            String attributeValue = attributes.get(requiredAttribute);
            if (attributeValue == null) {
                throw new IllegalArgumentException(type + " '" + requiredAttribute + "' is not available in the list of provided attributes.  Available " + type + "s: " + StringUtils.collectionToDelimitedString(attributes.keySet(), (String)", "));
            }
            String replacedValue = attributeValue.replace("\\", "\\\\");
            translations.put(RE.simplePatternToFullRegularExpression((String)("{" + requiredAttribute + "}")), replacedValue);
        }
        return translations;
    }

    protected String createPrefabCommand(Graph graph, String commandPrefix, File workDir, String reportName) {
        PrefabGraph prefabGraph = graph.getPrefabGraph();
        String[] rrds = DefaultRrdGraphService.getRrdNames(graph.getResource(), graph.getPrefabGraph().getColumns());
        StringBuffer buf = new StringBuffer();
        buf.append(commandPrefix);
        buf.append(" ");
        buf.append(prefabGraph.getCommand());
        String command = buf.toString();
        long startTime = graph.getStart().getTime();
        long endTime = graph.getEnd().getTime();
        long diffTime = endTime - startTime;
        String startTimeString = Long.toString(startTime / 1000L);
        String endTimeString = Long.toString(endTime / 1000L);
        String diffTimeString = Long.toString(diffTime / 1000L);
        HashMap<String, String> translationMap = new HashMap<String, String>();
        for (int i = 0; i < rrds.length; ++i) {
            String key = "{rrd" + (i + 1) + "}";
            translationMap.put(RE.simplePatternToFullRegularExpression((String)key), rrds[i]);
        }
        translationMap.put(RE.simplePatternToFullRegularExpression((String)"{startTime}"), startTimeString);
        translationMap.put(RE.simplePatternToFullRegularExpression((String)"{endTime}"), endTimeString);
        translationMap.put(RE.simplePatternToFullRegularExpression((String)"{diffTime}"), diffTimeString);
        try {
            translationMap.putAll(DefaultRrdGraphService.getTranslationsForAttributes(graph.getResource().getExternalValueAttributes(), prefabGraph.getExternalValues(), "external value attribute"));
            translationMap.putAll(DefaultRrdGraphService.getTranslationsForAttributes(graph.getResource().getStringPropertyAttributes(), prefabGraph.getPropertiesValues(), "string property attribute"));
        }
        catch (RuntimeException e) {
            LogUtils.errorf((Object)this, (String)"Invalid attributes were found on resource '%s'", (Object[])new Object[]{graph.getResource().getId()});
            throw e;
        }
        try {
            for (Map.Entry translation : translationMap.entrySet()) {
                RE re = new RE((String)translation.getKey());
                command = re.subst(command, (String)translation.getValue());
            }
        }
        catch (RESyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression syntax, check rrd-properties file", e);
        }
        return command;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property has not been set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property has not been set");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"rrdDao property has not been set");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }
}

