/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.snmpinfo;

import java.net.UnknownHostException;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

@XmlRootElement(name="snmp-info")
public class SnmpInfo {
    private String m_community;
    private String m_version;
    private int m_port;
    private int m_retries;
    private int m_timeout;

    public SnmpInfo() {
    }

    public SnmpInfo(SnmpAgentConfig config) {
        this.m_community = config.getReadCommunity();
        this.m_port = config.getPort();
        this.m_timeout = config.getTimeout();
        this.m_retries = config.getRetries();
        this.m_version = config.getVersionAsString();
    }

    public String getCommunity() {
        return this.m_community;
    }

    public void setCommunity(String community) {
        this.m_community = community;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public SnmpEventInfo createEventInfo(String ipAddr) throws UnknownHostException {
        SnmpEventInfo eventInfo = new SnmpEventInfo();
        eventInfo.setCommunityString(this.m_community);
        eventInfo.setVersion(this.m_version);
        eventInfo.setPort(this.m_port);
        eventInfo.setTimeout(this.m_timeout);
        eventInfo.setRetryCount(this.m_retries);
        eventInfo.setFirstIPAddress(ipAddr);
        return eventInfo;
    }
}

