/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collections;
import java.util.Comparator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="users")
@Transactional
public class UserRestService
extends OnmsRestService {
    @Autowired
    private UserManager m_userManager;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsUserList getUsers() {
        this.readLock();
        try {
            OnmsUserList list = this.m_userManager.getOnmsUserList();
            Collections.sort(list, new Comparator<OnmsUser>(){

                @Override
                public int compare(OnmsUser a, OnmsUser b) {
                    return a.getUsername().compareTo(b.getUsername());
                }
            });
            OnmsUserList onmsUserList = list;
            return onmsUserList;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.readUnlock();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{username}")
    public OnmsUser getUser(@PathParam(value="username") String username) {
        this.readLock();
        try {
            OnmsUser user = this.m_userManager.getOnmsUser(username);
            if (user != null) {
                OnmsUser onmsUser = user;
                return onmsUser;
            }
            try {
                throw this.getException(Response.Status.NOT_FOUND, username + " does not exist");
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw this.getException(Response.Status.BAD_REQUEST, t);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addUser(OnmsUser user) {
        this.writeLock();
        try {
            this.log().debug("addUser: Adding user " + user);
            this.m_userManager.save(user);
            Response response = Response.ok((Object)user).build();
            return response;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{userCriteria}")
    public Response updateUser(@PathParam(value="userCriteria") String userCriteria, MultivaluedMapImpl params) {
        OnmsUser user = null;
        this.writeLock();
        try {
            try {
                user = this.m_userManager.getOnmsUser(userCriteria);
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.BAD_REQUEST, t);
            }
            if (user == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateUser: User does not exist: " + userCriteria);
            }
            this.log().debug("updateUser: updating user " + user);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)user);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            this.log().debug("updateUser: user " + user + " updated");
            try {
                this.m_userManager.save(user);
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.ok((Object)user).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{userCriteria}")
    public Response deleteUser(@PathParam(value="userCriteria") String userCriteria) {
        this.writeLock();
        try {
            OnmsUser user = null;
            try {
                user = this.m_userManager.getOnmsUser(userCriteria);
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.BAD_REQUEST, t);
            }
            if (user == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteUser: User does not exist: " + userCriteria);
            }
            this.log().debug("deleteUser: deleting user " + user);
            try {
                this.m_userManager.deleteUser(user.getUsername());
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

