/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsOutageCollection;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="outages")
public class OutageRestService
extends OnmsRestService {
    @Autowired
    private OutageDao m_outageDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    SecurityContext m_securityContext;
    @Context
    ServletContext m_servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{outageId}")
    @Transactional
    public OnmsOutage getOutage(@PathParam(value="outageId") String outageId) {
        this.readLock();
        try {
            OnmsOutage onmsOutage = (OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(outageId));
            return onmsOutage;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_outageDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsOutageCollection getOutages() {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            OnmsOutageCollection coll = new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(this.m_outageDao.countMatching(builder.count().toCriteria()));
            OnmsOutageCollection onmsOutageCollection = coll;
            return onmsOutageCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="forNode/{nodeId}")
    public OnmsOutageCollection forNodeId(@PathParam(value="nodeId") int nodeId) {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsOutage.class);
            builder.eq("node.id", (Object)nodeId);
            Date d = new Date(System.currentTimeMillis() - 604800L);
            builder.or((Restriction)Restrictions.isNull((String)"ifRegainedService"), (Restriction)Restrictions.gt((String)"ifRegainedService", (Object)d));
            builder.alias("monitoredService", "monitoredService");
            builder.alias("monitoredService.ipInterface", "ipInterface");
            builder.alias("monitoredService.ipInterface.node", "node");
            builder.alias("monitoredService.serviceType", "serviceType");
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            builder.orderBy("id").desc();
            OnmsOutageCollection onmsOutageCollection = new OnmsOutageCollection((Collection)this.m_outageDao.findMatching(builder.toCriteria()));
            return onmsOutageCollection;
        }
        finally {
            this.readUnlock();
        }
    }
}

