/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.web.rest.ISO8601DateEditor;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.support.InetAddressTypeEditor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessorFactory;

public class OnmsRestService {
    private final ReentrantReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static final int DEFAULT_LIMIT = 10;

    protected void readLock() {
        this.m_readLock.lock();
    }

    protected void readUnlock() {
        if (this.m_globalLock.getReadHoldCount() > 0) {
            this.m_readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.m_globalLock.getWriteHoldCount() == 0) {
            while (this.m_globalLock.getReadHoldCount() > 0) {
                this.m_readLock.unlock();
            }
            this.m_writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.m_globalLock.getWriteHoldCount() > 0) {
            this.m_writeLock.unlock();
        }
    }

    protected void applyQueryFilters(MultivaluedMap<String, String> p, CriteriaBuilder builder) {
        String match;
        String query;
        com.sun.jersey.core.util.MultivaluedMapImpl params = new com.sun.jersey.core.util.MultivaluedMapImpl();
        params.putAll(p);
        builder.distinct();
        builder.limit(Integer.valueOf(10));
        params.remove((Object)"_dc");
        if (params.containsKey((Object)"limit")) {
            builder.limit(Integer.valueOf((String)params.getFirst((Object)"limit")));
            params.remove((Object)"limit");
        }
        if (params.containsKey((Object)"offset")) {
            builder.offset(Integer.valueOf((String)params.getFirst((Object)"offset")));
            params.remove((Object)"offset");
        }
        if (params.containsKey((Object)"start")) {
            builder.offset(Integer.valueOf((String)params.getFirst((Object)"start")));
            params.remove((Object)"start");
        }
        if (params.containsKey((Object)"orderBy")) {
            builder.orderBy((String)params.getFirst((Object)"orderBy"));
            params.remove((Object)"orderBy");
            if (params.containsKey((Object)"order")) {
                if ("desc".equalsIgnoreCase((String)params.getFirst((Object)"order"))) {
                    builder.desc();
                } else {
                    builder.asc();
                }
                params.remove((Object)"order");
            }
        }
        if ((query = this.removeParameter((MultivaluedMap<String, String>)params, "query")) != null) {
            builder.sql((Object)query);
        }
        String matchType = (match = this.removeParameter((MultivaluedMap<String, String>)params, "match")) == null ? "all" : match;
        builder.match(matchType);
        Class criteriaClass = builder.toCriteria().getCriteriaClass();
        BeanWrapper wrapper = this.getBeanWrapperForClass(criteriaClass);
        String comparatorParam = this.removeParameter((MultivaluedMap<String, String>)params, "comparator", "eq").toLowerCase();
        Criteria currentCriteria = builder.toCriteria();
        for (String key : params.keySet()) {
            for (String paramValue : (List)params.get((Object)key)) {
                Object value;
                if ("null".equalsIgnoreCase(paramValue)) {
                    builder.isNull(key);
                    continue;
                }
                if ("notnull".equalsIgnoreCase(paramValue)) {
                    builder.isNotNull(key);
                    continue;
                }
                Class<Object> type = Object.class;
                try {
                    type = currentCriteria.getType(key);
                }
                catch (IntrospectionException e) {
                    LogUtils.debugf((Object)this, (String)"Unable to determine type for key %s", (Object[])new Object[]{key});
                }
                if (type == null) {
                    type = Object.class;
                }
                LogUtils.warnf((Object)this, (String)"comparator = %s, key = %s, propertyType = %s", (Object[])new Object[]{comparatorParam, key, type});
                if (comparatorParam.equals("contains") || comparatorParam.equals("iplike") || comparatorParam.equals("ilike") || comparatorParam.equals("like")) {
                    value = paramValue;
                } else {
                    LogUtils.debugf((Object)this, (String)"convertIfNecessary(%s, %s)", (Object[])new Object[]{key, paramValue});
                    try {
                        value = wrapper.convertIfNecessary((Object)paramValue, type);
                    }
                    catch (Throwable t) {
                        LogUtils.debugf((Object)this, (Throwable)t, (String)"failed to introspect (key = %s, value = %s)", (Object[])new Object[]{key, paramValue});
                        value = paramValue;
                    }
                }
                try {
                    Method m = builder.getClass().getMethod(comparatorParam, String.class, Object.class);
                    m.invoke((Object)builder, key, value);
                }
                catch (Throwable t) {
                    LogUtils.warnf((Object)this, (Throwable)t, (String)"Unable to find method for comparator: %s, key: %s, value: %s", (Object[])new Object[]{comparatorParam, key, value});
                }
            }
        }
    }

    protected BeanWrapper getBeanWrapperForClass(Class<?> criteriaClass) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(criteriaClass);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        return wrapper;
    }

    protected String removeParameter(MultivaluedMap<String, String> params, String key) {
        if (params.containsKey((Object)key)) {
            String value = (String)params.getFirst((Object)key);
            params.remove((Object)key);
            return value;
        }
        return null;
    }

    protected String removeParameter(MultivaluedMap<String, String> params, String key, String defaultValue) {
        String value = this.removeParameter(params, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Object convertIfNecessary(BeanWrapper wrapper, String key, String stringValue) {
        LogUtils.debugf((Object)this, (String)"convertIfNecessary(%s, %s)", (Object[])new Object[]{key, stringValue});
        return wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
    }

    protected <T> WebApplicationException getException(Response.Status status, String msg) throws WebApplicationException {
        this.log().error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected <T> WebApplicationException getException(Response.Status status, Throwable t) throws WebApplicationException {
        this.log().error(t.getMessage(), t);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)t.getMessage()).build());
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public static String convertNameToPropertyName(String name) {
        StringBuffer result = new StringBuffer();
        boolean nextIsUpper = false;
        if (name != null && name.length() > 0) {
            if (name.length() > 1 && (name.substring(1, 2).equals("_") || name.substring(1, 2).equals("-"))) {
                result.append(name.substring(0, 1).toUpperCase());
            } else {
                result.append(name.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals("_") || s.equals("-")) {
                    nextIsUpper = true;
                    continue;
                }
                if (nextIsUpper) {
                    result.append(s.toUpperCase());
                    nextIsUpper = false;
                    continue;
                }
                result.append(s.toLowerCase());
            }
        }
        return result.toString();
    }

    protected void setProperties(MultivaluedMapImpl params, Object req) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)req);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        for (String key : params.keySet()) {
            String propertyName = OnmsRestService.convertNameToPropertyName(key);
            if (!wrapper.isWritableProperty(propertyName)) continue;
            Object value = null;
            String stringValue = params.getFirst(key);
            value = this.convertIfNecessary(wrapper, propertyName, stringValue);
            wrapper.setPropertyValue(propertyName, value);
        }
    }

    protected static enum ComparisonOperation {
        EQ,
        NE,
        ILIKE,
        LIKE,
        IPLIKE,
        GT,
        LT,
        GE,
        LE,
        CONTAINS;

    }
}

