/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsMonitoredServiceResource;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsIpInterfaceResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    ResourceContext m_context;
    @Context
    UriInfo m_uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsIpInterfaceList getIpInterfaces(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            LogUtils.debugf((Object)this, (String)"getIpInterfaces: reading interfaces for node %s", (Object[])new Object[]{nodeCriteria});
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            MultivaluedMap params = this.m_uriInfo.getQueryParameters();
            CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
            builder.ne("isManaged", (Object)"D");
            builder.limit(Integer.valueOf(20));
            this.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
            builder.alias("node", "node");
            builder.eq("node.id", (Object)node.getId());
            OnmsIpInterfaceList interfaceList = new OnmsIpInterfaceList((Collection)this.m_ipInterfaceDao.findMatching(builder.toCriteria()));
            interfaceList.setTotalCount(this.m_ipInterfaceDao.countMatching(builder.count().toCriteria()));
            OnmsIpInterfaceList onmsIpInterfaceList = interfaceList;
            return onmsIpInterfaceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ipAddress}")
    public OnmsIpInterface getIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getIpInterface: can't find node " + nodeCriteria);
            }
            OnmsIpInterface onmsIpInterface = node.getIpInterfaceByIpAddress(InetAddressUtils.getInetAddress((String)ipAddress));
            return onmsIpInterface;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsIpInterface ipInterface) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addIpInterface: can't find node " + nodeCriteria);
            }
            if (ipInterface == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface object cannot be null");
            }
            if (ipInterface.getIpAddress() == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface's ipAddress cannot be null");
            }
            if (ipInterface.getIpAddress().getAddress() == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface's ipAddress bytes cannot be null");
            }
            LogUtils.debugf((Object)this, (String)"addIpInterface: adding interface %s", (Object[])new Object[]{ipInterface});
            node.addIpInterface(ipInterface);
            this.m_ipInterfaceDao.save((Object)ipInterface);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedInterface", this.getClass().getName());
            bldr.setNodeid((long)node.getId().intValue());
            bldr.setInterface(ipInterface.getIpAddress());
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            Response response = Response.ok((Object)ipInterface).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ipAddress}")
    public Response updateIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria);
            }
            OnmsIpInterface ipInterface = node.getIpInterfaceByIpAddress(ipAddress);
            if (ipInterface == null) {
                throw this.getException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
            }
            LogUtils.debugf((Object)this, (String)"updateIpInterface: updating ip interface %s", (Object[])new Object[]{ipInterface});
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)ipInterface);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LogUtils.debugf((Object)this, (String)"updateIpInterface: ip interface %s updated", (Object[])new Object[]{ipInterface});
            this.m_ipInterfaceDao.saveOrUpdate((Object)ipInterface);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ipAddress}")
    public Response deleteIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(InetAddressUtils.getInetAddress((String)ipAddress));
            if (intf == null) {
                throw this.getException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
            }
            LogUtils.debugf((Object)this, (String)"deleteIpInterface: deleting interface %s from node %s", (Object[])new Object[]{ipAddress, nodeCriteria});
            node.getIpInterfaces().remove(intf);
            this.m_nodeDao.save((Object)node);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/interfaceDeleted", this.getClass().getName());
            bldr.setNodeid((long)node.getId().intValue());
            bldr.setInterface(InetAddressUtils.addr((String)ipAddress));
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{ipAddress}/services")
    public OnmsMonitoredServiceResource getServices() {
        this.readLock();
        try {
            OnmsMonitoredServiceResource onmsMonitoredServiceResource = (OnmsMonitoredServiceResource)this.m_context.getResource(OnmsMonitoredServiceResource.class);
            return onmsMonitoredServiceResource;
        }
        finally {
            this.readUnlock();
        }
    }
}

