/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.util.Collections;
import java.util.Comparator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="groups")
@Transactional
public class GroupRestService
extends OnmsRestService {
    @Autowired
    private GroupManager m_groupManager;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsGroupList getGroups() {
        this.readLock();
        try {
            OnmsGroupList list = this.m_groupManager.getOnmsGroupList();
            Collections.sort(list, new Comparator<OnmsGroup>(){

                @Override
                public int compare(OnmsGroup a, OnmsGroup b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            OnmsGroupList onmsGroupList = list;
            return onmsGroupList;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.readUnlock();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{groupName}")
    public OnmsGroup getGroup(@PathParam(value="groupName") String groupName) {
        this.readLock();
        try {
            OnmsGroup group = this.m_groupManager.getOnmsGroup(groupName);
            if (group != null) {
                OnmsGroup onmsGroup = group;
                return onmsGroup;
            }
            try {
                throw this.getException(Response.Status.NOT_FOUND, groupName + " does not exist");
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw this.getException(Response.Status.BAD_REQUEST, t);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addGroup(OnmsGroup group) {
        this.writeLock();
        try {
            this.log().debug("addGroup: Adding group " + group);
            this.m_groupManager.save(group);
            Response response = Response.ok((Object)group).build();
            return response;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{groupName}")
    public Response updateGroup(@PathParam(value="groupName") String groupName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsGroup group = null;
            try {
                group = this.m_groupManager.getOnmsGroup(groupName);
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.BAD_REQUEST, t);
            }
            if (group == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateGroup: Group does not exist: " + groupName);
            }
            this.log().debug("updateGroup: updating group " + group);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)group);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            this.log().debug("updateGroup: group " + group + " updated");
            try {
                this.m_groupManager.save(group);
            }
            catch (Throwable t) {
                throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.ok((Object)group).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{groupName}")
    public Response deleteGroup(@PathParam(value="groupName") String groupName) {
        this.writeLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            this.log().debug("deleteGroup: deleting group " + group);
            this.m_groupManager.deleteGroup(groupName);
            Response response = Response.ok().build();
            return response;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{groupName}/users/{userName}")
    public Response addUser(@PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        this.writeLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            group.addUser(userName);
            this.m_groupManager.save(group);
            Response response = Response.ok().build();
            return response;
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{groupName}/users/{userName}")
    public Response removeUser(@PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        this.writeLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            if (group.getUsers().contains(userName)) {
                group.removeUser(userName);
                this.m_groupManager.save(group);
                Response response = Response.ok().build();
                return response;
            }
            try {
                throw this.getException(Response.Status.BAD_REQUEST, "User is not in the group '" + groupName + "': " + userName);
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    protected OnmsGroup getOnmsGroup(String groupName) {
        OnmsGroup group = null;
        try {
            group = this.m_groupManager.getOnmsGroup(groupName);
        }
        catch (Throwable t) {
            throw this.getException(Response.Status.BAD_REQUEST, t);
        }
        if (group == null) {
            throw this.getException(Response.Status.BAD_REQUEST, "Group does not exist: " + groupName);
        }
        return group;
    }
}

