/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.DataLinkInterfaceList;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="links")
@Transactional
public class DataLinkInterfaceRestService
extends OnmsRestService {
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    ResourceContext m_context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public DataLinkInterfaceList getLinks() {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(DataLinkInterface.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            builder.orderBy("lastPollTime").desc();
            DataLinkInterfaceList dataLinkInterfaceList = new DataLinkInterfaceList((Collection)this.m_dataLinkInterfaceDao.findMatching(builder.toCriteria()));
            return dataLinkInterfaceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{linkId}")
    public DataLinkInterface getLink(@PathParam(value="linkId") int linkId) {
        this.readLock();
        try {
            DataLinkInterface dataLinkInterface = (DataLinkInterface)this.m_dataLinkInterfaceDao.get((Serializable)Integer.valueOf(linkId));
            return dataLinkInterface;
        }
        finally {
            this.readUnlock();
        }
    }
}

