/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class ServiceFilter
extends EqualsFilter<Integer> {
    public static final String TYPE = "service";

    public ServiceFilter(int serviceId) {
        super(TYPE, SQLType.INT, "OUTAGES.SERVICEID", "serviceType.id", serviceId);
    }

    public String getTextDescription(ServletContext servletContext) {
        int serviceId = this.getServiceId();
        String serviceName = Integer.toString(serviceId);
        serviceName = NetworkElementFactory.getInstance(servletContext).getServiceNameFromId(serviceId);
        return "service is " + serviceName;
    }

    @Override
    public String toString() {
        return "<ServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

