/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.osgi;

import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.osgid.Osgid;
import org.osgi.framework.BundleContext;

public class FrameworkStartupContextListener
implements ServletContextListener {
    private Osgid m_service;

    public void contextDestroyed(ServletContextEvent event) {
        try {
            this.m_service.destroy();
            FileUtils.deleteDirectory((File)new File(event.getServletContext().getRealPath("/") + File.separator + "WEB-INF" + File.separator + "karaf" + File.separator + "data"));
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Could not start up OSGi container: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.m_service = new Osgid();
            this.m_service.setHomeDirectory(sce.getServletContext().getRealPath("/") + File.separator + "WEB-INF" + File.separator + "karaf");
            this.m_service.start();
            sce.getServletContext().setAttribute(BundleContext.class.getName(), (Object)this.m_service.getBundleContext());
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Could not start up OSGi container: %s", (Object[])new Object[]{e.getMessage()});
        }
    }
}

