/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class VLink {
    private final String elem1Type;
    private final int elem1Id;
    private final String elem2Type;
    private final int elem2Id;
    private final Set<Integer> nodeids = new TreeSet<Integer>();
    private final Map<String, Integer> vlinkStatusMap = new HashMap<String, Integer>();
    private int numberOfLinks;
    private int linkTypeId;
    private String linkStatusString;
    private final String id;

    public VLink(int elem1Id, String elem1Type, int elem2Id, String elem2Type, int linkTypeId) {
        this.elem1Type = elem1Type;
        this.elem2Type = elem2Type;
        this.elem1Id = elem1Id;
        this.elem2Id = elem2Id;
        this.linkTypeId = linkTypeId;
        this.numberOfLinks = 1;
        String a = elem1Id + elem1Type;
        String b = elem2Id + elem2Type;
        String id = a + "-" + b;
        if (elem1Id > elem2Id) {
            id = b + "-" + a;
        }
        if (elem1Id == elem2Id && elem2Type.equals("M")) {
            id = b + "-" + a;
        }
        this.id = id = id + "-" + linkTypeId;
    }

    public Map<String, Integer> getVlinkStatusMap() {
        return this.vlinkStatusMap;
    }

    public void setVlinkStatusMap(Map<String, Integer> vlinkStatusMap) {
        this.vlinkStatusMap.clear();
        this.vlinkStatusMap.putAll(vlinkStatusMap);
    }

    public int getNumberOfLinks() {
        return this.numberOfLinks;
    }

    public void setNumberOfLinks(int numberOfLinks) {
        this.numberOfLinks = numberOfLinks;
    }

    public String getLinkStatusString() {
        return this.linkStatusString;
    }

    public void setLinkStatusString(String linkStatusString) {
        this.linkStatusString = linkStatusString;
    }

    public boolean equals(Object otherLink) {
        if (!(otherLink instanceof VLink)) {
            return false;
        }
        VLink link = (VLink)otherLink;
        if (!this.getId().equals(link.getId())) {
            return false;
        }
        for (int nodeid : this.getNodeids()) {
            if (link.getNodeids().contains(nodeid)) continue;
            return false;
        }
        for (int nodeid : link.getNodeids()) {
            if (this.getNodeids().contains(nodeid)) continue;
            return false;
        }
        return true;
    }

    public String getFirst() {
        return this.elem1Id + this.elem1Type;
    }

    public String getSecond() {
        return this.elem2Id + this.elem2Type;
    }

    public int getLinkTypeId() {
        return this.linkTypeId;
    }

    public void setLinkTypeId(int typeId) {
        this.linkTypeId = typeId;
    }

    public String toString() {
        return "" + this.getFirst() + "-" + this.getSecond() + "-" + this.linkTypeId + "-" + this.linkStatusString + " nodeids:" + this.nodeids.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getIdWithoutLinkType() {
        return this.id.substring(0, this.id.lastIndexOf("-"));
    }

    public int increaseLinks() {
        return ++this.numberOfLinks;
    }

    public int increaseStatusMapLinks(String statusString) {
        int i = 0;
        if (this.vlinkStatusMap.containsKey(statusString)) {
            i = this.vlinkStatusMap.get(statusString);
        }
        this.vlinkStatusMap.put(statusString, ++i);
        return i;
    }

    public Set<Integer> getNodeids() {
        return this.nodeids;
    }

    public void setNodeids(Set<Integer> nodeids) {
        this.nodeids.clear();
        nodeids.addAll(nodeids);
    }
}

