/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.graph;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.charts.ChartUtils;

public class PurdyChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 2449309268355063862L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String chartName = request.getParameter("chart-name");
        String buffered = request.getParameter("buffered");
        if (chartName == null) {
            this.log().warn("doGet: request doesn't contain a chart-name parameter.");
            return;
        }
        if (buffered == null) {
            buffered = "0";
        }
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        this.log().debug("doGet: displaying chart: " + chartName);
        try {
            ChartUtils.getBarChartPNG((String)chartName, (OutputStream)out);
        }
        catch (MarshalException e) {
            this.log().error("Error marshalling chart-configuration.xml: ", (Throwable)e);
        }
        catch (ValidationException e) {
            this.log().error("Error validating chart-configuration.xml: ", (Throwable)e);
        }
        catch (IOException e) {
            this.log().error("Error reading chart-configuration.xml: ", (Throwable)e);
        }
        catch (SQLException e) {
            this.log().error("Error in SQL for chart: " + chartName, (Throwable)e);
        }
        out.flush();
        out.close();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }
}

