/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.NetworkElementFactoryInterface;
import org.opennms.web.filter.NotEqualOrNullFilter;
import org.opennms.web.filter.SQLType;
import org.springframework.context.ApplicationContext;

public class NegativeServiceFilter
extends NotEqualOrNullFilter<Integer> {
    public static final String TYPE = "servicenot";
    private ServletContext m_servletContext;
    private ApplicationContext m_appContext;
    protected int serviceId;

    public NegativeServiceFilter(int serviceId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "EVENTS.SERVICEID", "serviceType.id", serviceId);
        this.m_servletContext = servletContext;
    }

    public NegativeServiceFilter(int serviceId, ApplicationContext appContext) {
        super(TYPE, SQLType.INT, "EVENTS.SERVICEID", "serviceType.id", serviceId);
        this.m_appContext = appContext;
    }

    @Override
    public String getTextDescription() {
        NetworkElementFactoryInterface factory = this.m_servletContext == null ? NetworkElementFactory.getInstance(this.m_appContext) : NetworkElementFactory.getInstance(this.m_servletContext);
        String serviceName = factory.getServiceNameFromId(this.getServiceId());
        return "service is not " + serviceName;
    }

    @Override
    public String toString() {
        return "<WebEventRepository.NegativeServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

