/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.EventIdListFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcWebEventRepository
implements WebEventRepository,
InitializingBean {
    @Autowired
    SimpleJdbcTemplate m_simpleJdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private String getSql(String selectClause, EventCriteria criteria) {
        final StringBuilder buf = new StringBuilder(selectClause);
        criteria.visit(new EventCriteria.EventCriteriaVisitor<RuntimeException>(){
            boolean first = true;

            public void and(StringBuilder buf2) {
                if (this.first) {
                    buf2.append(" WHERE ");
                    this.first = false;
                } else {
                    buf2.append(" AND ");
                }
            }

            @Override
            public void visitAckType(AcknowledgeType ackType) {
                this.and(buf);
                buf.append(ackType.getAcknowledgeTypeClause());
            }

            @Override
            public void visitFilter(Filter filter) {
                this.and(buf);
                buf.append(filter.getParamSql());
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) {
                buf.append(" ");
                buf.append(sortStyle.getOrderByClause());
            }

            @Override
            public void visitLimit(int limit, int offset) {
                buf.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
            }
        });
        return buf.toString();
    }

    private PreparedStatementSetter paramSetter(final EventCriteria criteria, final Object ... args) {
        return new PreparedStatementSetter(){
            int paramIndex = 1;

            public void setValues(final PreparedStatement ps) throws SQLException {
                for (Object arg : args) {
                    ps.setObject(this.paramIndex, arg);
                    ++this.paramIndex;
                }
                criteria.visit(new EventCriteria.BaseEventCriteriaVisitor<SQLException>(){

                    @Override
                    public void visitFilter(Filter filter) throws SQLException {
                        paramIndex += filter.bindParam(ps, paramIndex);
                    }
                });
            }
        };
    }

    @Override
    public int countMatchingEvents(EventCriteria criteria) {
        String sql = this.getSql("SELECT COUNT(EVENTID) as EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ", criteria);
        return this.queryForInt(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public int[] countMatchingEventsBySeverity(EventCriteria criteria) {
        String selectClause = "SELECT EVENTSEVERITY, COUNT(*) AS EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ";
        String sql = this.getSql(selectClause, criteria);
        sql = sql + " GROUP BY EVENTSEVERITY";
        final int[] alarmCounts = new int[8];
        this.jdbc().query(sql, this.paramSetter(criteria, new Object[0]), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                int alarmCount;
                int severity = rs.getInt("EVENTSEVERITY");
                alarmCounts[severity] = alarmCount = rs.getInt("EVENTCOUNT");
            }
        });
        return alarmCounts;
    }

    @Override
    public Event getEvent(int eventId) {
        Event[] events = this.getMatchingEvents(new EventCriteria(new EventIdFilter(eventId)));
        if (events.length < 1) {
            return null;
        }
        return events[0];
    }

    @Override
    public Event[] getMatchingEvents(EventCriteria criteria) {
        String sql = this.getSql("SELECT EVENTS.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ", criteria);
        return this.getEvents(sql, this.paramSetter(criteria, new Object[0]));
    }

    private Event[] getEvents(String sql, PreparedStatementSetter setter) {
        List<Event> events = this.queryForList(sql, setter, new EventMapper());
        return events.toArray(new Event[0]);
    }

    void acknowledgeEvents(String user, Date timestamp, int[] eventIds) {
        this.acknowledgeMatchingEvents(user, timestamp, new EventCriteria(new EventIdListFilter(eventIds)));
    }

    @Override
    public void acknowledgeAll(String user, Date timestamp) {
        this.m_simpleJdbcTemplate.update("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? WHERE EVENTACKUSER IS NULL ", new Object[]{user, new Timestamp(timestamp.getTime())});
    }

    @Override
    public void acknowledgeMatchingEvents(String user, Date timestamp, EventCriteria criteria) {
        String sql = this.getSql("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? ", criteria);
        this.jdbc().update(sql, this.paramSetter(criteria, user, new Timestamp(timestamp.getTime())));
    }

    @Override
    public void unacknowledgeAll() {
        this.m_simpleJdbcTemplate.update("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL WHERE EVENTACKUSER IS NOT NULL ", new Object[0]);
    }

    @Override
    public void unacknowledgeMatchingEvents(EventCriteria criteria) {
        String sql = this.getSql("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=null ", criteria);
        this.jdbc().update(sql, this.paramSetter(criteria, new Object[0]));
    }

    private int queryForInt(String sql, PreparedStatementSetter setter) throws DataAccessException {
        Integer number = (Integer)this.queryForObject(sql, setter, (RowMapper)new SingleColumnRowMapper(Integer.class));
        return number != null ? number : 0;
    }

    private <T> T queryForObject(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1))));
    }

    private <T> List<T> queryForList(String sql, PreparedStatementSetter setter, ParameterizedRowMapper<T> rm) {
        return (List)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rm));
    }

    private JdbcOperations jdbc() {
        return this.m_simpleJdbcTemplate.getJdbcOperations();
    }

    public static class EventMapper
    implements ParameterizedRowMapper<Event> {
        public Event mapRow(ResultSet rs, int rowNum) throws SQLException {
            Event event = new Event();
            event.id = new Integer(rs.getInt("eventID"));
            event.uei = rs.getString("eventUei");
            event.snmp = rs.getString("eventSnmp");
            event.time = new Date(rs.getTimestamp("eventTime").getTime());
            event.host = rs.getString("eventHost");
            event.snmphost = rs.getString("eventSnmpHost");
            event.dpName = rs.getString("eventDpName");
            event.parms = rs.getString("eventParms");
            Object element = rs.getObject("nodeID");
            event.nodeID = element == null ? new Integer(0) : (Integer)element;
            event.ipAddr = rs.getString("ipAddr");
            event.serviceID = (Integer)rs.getObject("serviceID");
            event.nodeLabel = rs.getString("nodeLabel");
            event.serviceName = rs.getString("serviceName");
            event.createTime = new Date(rs.getTimestamp("eventCreateTime").getTime());
            event.description = rs.getString("eventDescr");
            event.logGroup = rs.getString("eventLoggroup");
            event.logMessage = rs.getString("eventLogmsg");
            event.severity = OnmsSeverity.get((int)rs.getInt("eventSeverity"));
            event.operatorInstruction = rs.getString("eventOperInstruct");
            event.autoAction = rs.getString("eventAutoAction");
            event.operatorAction = rs.getString("eventOperAction");
            event.operatorActionMenuText = rs.getString("eventOperActionMenuText");
            event.notification = rs.getString("eventNotification");
            event.troubleTicket = rs.getString("eventTticket");
            event.troubleTicketState = (Integer)rs.getObject("eventTticketState");
            event.forward = rs.getString("eventForward");
            event.mouseOverText = rs.getString("eventMouseOverText");
            event.acknowledgeUser = rs.getString("eventAckUser");
            event.acknowledgeTime = this.getTimestamp("eventAckTime", rs);
            event.alarmId = (Integer)rs.getObject("alarmid");
            event.eventDisplay = rs.getString("eventDisplay").equals("Y");
            return event;
        }

        private Date getTimestamp(String field, ResultSet rs) throws SQLException {
            if (rs.getTimestamp(field) != null) {
                return new Date(rs.getTimestamp(field).getTime());
            }
            return null;
        }
    }
}

