/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.HashMap;
import java.util.Map;

public class StpNode {
    int m_nodeId;
    int m_basenumports;
    int m_basetype;
    int m_stpprotocolspecification;
    int m_stppriority;
    int m_stprootcost;
    int m_stprootport;
    int m_basevlan;
    String m_basevlanname;
    String m_basebridgeaddress;
    String m_stpdesignatedroot;
    String m_lastPollTime;
    char m_status;
    int m_stprootnodeid;
    private static final String[] BRIDGE_BASE_TYPE = new String[]{null, "Unknown", "Transparent-Only", "Source-Route-Only", "SRT"};
    private static final String[] STP_PROTO_TYPE = new String[]{null, "Unknown", "DEC LAN Bridge", "IEEE 802.1D"};
    private static final Map<Character, String> statusMap = new HashMap<Character, String>();

    StpNode() {
    }

    StpNode(int nodeId, int basenumports, int basetype, int stpprotocolspecification, int stppriority, int stprootcost, int stprootport, int basevlan, String basevlanname, String basebridgeaddress, String stpdesignatedroot, String lastPollTime, char status, int stprootnodeid) {
        this.m_nodeId = nodeId;
        this.m_basenumports = basenumports;
        this.m_basetype = basetype;
        this.m_stpprotocolspecification = stpprotocolspecification;
        this.m_stppriority = stppriority;
        this.m_stprootcost = stprootcost;
        this.m_stprootcost = stprootport;
        this.m_basevlan = basevlan;
        this.m_basevlanname = basevlanname;
        this.m_basebridgeaddress = basebridgeaddress;
        this.m_stpdesignatedroot = stpdesignatedroot;
        this.m_lastPollTime = lastPollTime;
        this.m_status = status;
        this.m_stprootnodeid = stprootnodeid;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Bridge number of ports = " + this.m_basenumports + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public String get_basebridgeaddress() {
        return this.m_basebridgeaddress;
    }

    public int get_basenumports() {
        return this.m_basenumports;
    }

    public int get_basetype() {
        return this.m_basetype;
    }

    public String getBaseType() {
        try {
            return BRIDGE_BASE_TYPE[this.m_basetype];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return BRIDGE_BASE_TYPE[1];
        }
    }

    public int get_basevlan() {
        return this.m_basevlan;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public char get_status() {
        return this.m_status;
    }

    public String get_stpdesignatedroot() {
        return this.m_stpdesignatedroot;
    }

    public int get_stppriority() {
        return this.m_stppriority;
    }

    public int get_stpprotocolspecification() {
        return this.m_stpprotocolspecification;
    }

    public String getStpProtocolSpecification() {
        try {
            return STP_PROTO_TYPE[this.m_stpprotocolspecification];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return STP_PROTO_TYPE[1];
        }
    }

    public int get_stprootcost() {
        return this.m_stprootcost;
    }

    public int get_stprootport() {
        return this.m_stprootport;
    }

    public int get_stprootnodeid() {
        return this.m_stprootnodeid;
    }

    public String getBaseVlanName() {
        return this.m_basevlanname;
    }

    public String getStatusString() {
        return statusMap.get(new Character(this.m_status));
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_basevlan == 0) {
            return "";
        }
        if (this.m_basevlan == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_basevlan * redoffset) % 255;
        green = (green + this.m_basevlan * greenoffset) % 255;
        blue = (blue + this.m_basevlan * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    static {
        statusMap.put(Character.valueOf('A'), "Active");
        statusMap.put(Character.valueOf('K'), "Unknown");
        statusMap.put(Character.valueOf('D'), "Deleted");
        statusMap.put(Character.valueOf('N'), "Not Active");
    }
}

