/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.inventory;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opennms.report.configuration.svclayer.ConfigurationReportCriteria;
import org.opennms.report.configuration.svclayer.ConfigurationReportService;
import org.opennms.report.inventory.svclayer.InventoryReportCriteria;
import org.opennms.report.inventory.svclayer.InventoryReportService;
import org.opennms.web.controller.inventory.RancidReportExecCommClass;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class RancidReportExecController
extends SimpleFormController {
    ConfigurationReportService m_configurationReportService;
    InventoryReportService m_inventoryReportService;

    public ConfigurationReportService getConfigurationReportService() {
        return this.m_configurationReportService;
    }

    public void setConfigurationReportService(ConfigurationReportService configurationReportService) {
        this.m_configurationReportService = configurationReportService;
    }

    public InventoryReportService getInventoryReportService() {
        return this.m_inventoryReportService;
    }

    public void setInventoryReportService(InventoryReportService inventoryReportService) {
        this.m_inventoryReportService = inventoryReportService;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws ServletException, IOException, Exception {
        ConfigurationReportCriteria criteria;
        RancidReportExecController.log().debug((Object)"RancidReportExecController ModelAndView onSubmit");
        RancidReportExecCommClass bean = (RancidReportExecCommClass)command;
        RancidReportExecController.log().debug((Object)("RancidReportExecController ModelAndView type" + bean.getReporttype()));
        RancidReportExecController.log().debug((Object)("RancidReportExecController ModelAndView type" + bean.getFieldhas()));
        String user = request.getRemoteUser();
        Date reportRequestDate = new Date();
        ModelAndView mav = new ModelAndView(this.getSuccessView());
        if (bean.getReporttype().compareTo("rancidlist") == 0) {
            RancidReportExecController.log().debug((Object)"RancidReportExecController rancidlist report ");
            criteria = new ConfigurationReportCriteria(bean.getDate(), bean.getReportfiletype(), bean.getReportemail(), user, reportRequestDate);
            boolean done = this.m_configurationReportService.runReport(criteria);
            mav.addObject("type", (Object)"Rancid List");
            if (!done) {
                RancidReportExecController.log().debug((Object)"RancidReportExecController error ");
            }
        } else if (bean.getReporttype().compareTo("inventory") == 0) {
            RancidReportExecController.log().debug((Object)"RancidReportExecController inventory report ");
            criteria = new InventoryReportCriteria(bean.getDate(), bean.getFieldhas(), bean.getReportfiletype(), bean.getReportemail(), user, reportRequestDate);
            boolean done = this.m_inventoryReportService.runReport((InventoryReportCriteria)criteria);
            mav.addObject("type", (Object)"Inventory Report");
            if (!done) {
                RancidReportExecController.log().debug((Object)"RancidReportExecController error ");
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        try {
            mav.addObject("date", (Object)format.parse(bean.getDate()));
        }
        catch (ParseException pe) {
            mav.addObject("date", (Object)format.format(Calendar.getInstance().getTime()));
        }
        mav.addObject("searchfield", (Object)bean.getFieldhas());
        if (bean.getReportfiletype().compareTo("pdftype") == 0) {
            mav.addObject("reportformat", (Object)"PDF");
        } else {
            mav.addObject("reportformat", (Object)"HTML");
        }
        return mav;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        RancidReportExecController.log().debug((Object)"RancidReportExecController initBinder");
    }

    private static Logger log() {
        return Logger.getLogger((String)"Rancid");
    }
}

