/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.thresholds;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.EventconfFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.web.api.Util;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ThresholdController
extends AbstractController
implements InitializingBean {
    private static final String SAVE_BUTTON_TITLE = "Save";
    private static final String CANCEL_BUTTON_TITLE = "Cancel";
    private static final String ADDFILTER_BUTTON_TITLE = "Add";
    private static final String EDIT_BUTTON_TITLE = "Edit";
    private static final String DELETE_BUTTON_TITLE = "Delete";
    private static final String UPDATE_BUTTON_TITLE = "Update";
    private static final String MOVEUP_BUTTON_TITLE = "Up";
    private static final String MOVEDOWN_BUTTON_TITLE = "Down";
    private ResourceDao m_resourceDao;
    private boolean eventConfChanged = false;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView;
        ThresholdingConfigFactory.init();
        EventconfFactory.init();
        String editGroup = request.getParameter("editGroup");
        String deleteThreshold = request.getParameter("deleteThreshold");
        String editThreshold = request.getParameter("editThreshold");
        String newThreshold = request.getParameter("newThreshold");
        String finishThresholdEdit = request.getParameter("finishThresholdEdit");
        String deleteExpression = request.getParameter("deleteExpression");
        String editExpression = request.getParameter("editExpression");
        String newExpression = request.getParameter("newExpression");
        String finishExpressionEdit = request.getParameter("finishExpressionEdit");
        String groupName = request.getParameter("groupName");
        String reloadThreshdConfig = request.getParameter("reloadThreshdConfig");
        if (editGroup != null) {
            modelAndView = this.gotoGroupEdit(groupName);
        } else if (newThreshold != null) {
            modelAndView = this.gotoNewThreshold(groupName);
        } else if (editThreshold != null) {
            String thresholdIndexString = request.getParameter("thresholdIndex");
            modelAndView = this.gotoEditThreshold(thresholdIndexString, groupName);
        } else if (deleteThreshold != null) {
            String thresholdIndexString = request.getParameter("thresholdIndex");
            modelAndView = this.deleteThreshold(thresholdIndexString, groupName);
        } else if (finishThresholdEdit != null) {
            modelAndView = this.finishThresholdEdit(request);
        } else if (newExpression != null) {
            modelAndView = this.gotoNewExpression(groupName);
        } else if (editExpression != null) {
            String expressionIndexString = request.getParameter("expressionIndex");
            modelAndView = this.gotoEditExpression(expressionIndexString, groupName);
        } else if (deleteExpression != null) {
            String expressionIndexString = request.getParameter("expressionIndex");
            modelAndView = this.deleteExpression(expressionIndexString, groupName);
        } else {
            modelAndView = finishExpressionEdit != null ? this.finishExpressionEdit(request) : (reloadThreshdConfig != null ? this.reloadThreshdConfig() : this.gotoGroupList());
        }
        return modelAndView;
    }

    private ModelAndView gotoGroupEdit(String groupName) {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)configFactory.getGroup(groupName));
        return modelAndView;
    }

    private void addStandardEditingBits(ModelAndView modelAndView) {
        LinkedHashMap<String, String> dsTypes = new LinkedHashMap<String, String>();
        dsTypes.put("node", "Node");
        dsTypes.put("if", "Interface");
        Collection resourceTypes = this.m_resourceDao.getResourceTypes();
        TreeMultimap genericDsTypes = TreeMultimap.create();
        for (OnmsResourceType resourceType : resourceTypes) {
            if (!(resourceType instanceof GenericIndexResourceType)) continue;
            genericDsTypes.put((Object)resourceType.getLabel(), (Object)resourceType.getName());
        }
        for (String rtLabel : genericDsTypes.keys()) {
            Collection rtNames = genericDsTypes.get((Object)rtLabel);
            for (String rtName : rtNames) {
                if (rtNames.size() > 1) {
                    dsTypes.put(rtName, rtLabel + " [" + rtName + "]");
                    continue;
                }
                dsTypes.put(rtName, rtLabel);
            }
        }
        modelAndView.addObject("dsTypes", dsTypes);
        ArrayList<String> thresholdTypes = new ArrayList<String>();
        thresholdTypes.add("high");
        thresholdTypes.add("low");
        thresholdTypes.add("relativeChange");
        thresholdTypes.add("absoluteChange");
        thresholdTypes.add("rearmingAbsoluteChange");
        modelAndView.addObject("thresholdTypes", thresholdTypes);
        ArrayList<String> filterOperators = new ArrayList<String>();
        filterOperators.add("and");
        filterOperators.add("or");
        modelAndView.addObject("filterOperators", filterOperators);
        modelAndView.addObject("saveButtonTitle", (Object)SAVE_BUTTON_TITLE);
        modelAndView.addObject("cancelButtonTitle", (Object)CANCEL_BUTTON_TITLE);
        modelAndView.addObject("addFilterButtonTitle", (Object)ADDFILTER_BUTTON_TITLE);
        modelAndView.addObject("editButtonTitle", (Object)EDIT_BUTTON_TITLE);
        modelAndView.addObject("deleteButtonTitle", (Object)DELETE_BUTTON_TITLE);
        modelAndView.addObject("updateButtonTitle", (Object)UPDATE_BUTTON_TITLE);
        modelAndView.addObject("moveUpButtonTitle", (Object)MOVEUP_BUTTON_TITLE);
        modelAndView.addObject("moveDownButtonTitle", (Object)MOVEDOWN_BUTTON_TITLE);
    }

    private ModelAndView gotoNewThreshold(String groupName) {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        Group group = configFactory.getGroup(groupName);
        int thresholdIndex = group.getThresholdCount();
        Threshold threshold = null;
        if (thresholdIndex > 0) {
            threshold = group.getThreshold(thresholdIndex - 1);
            if (threshold.getDsName() == null || threshold.getDsName().equals("")) {
                --thresholdIndex;
            } else {
                threshold = null;
            }
        }
        if (threshold == null) {
            threshold = new Threshold();
            threshold.setDsType("node");
            threshold.setType("high");
            threshold.setTrigger(1);
            group.addThreshold(threshold);
        }
        if (threshold != group.getThreshold(thresholdIndex)) {
            for (int i = 0; i < group.getThresholdCount(); ++i) {
                if (threshold != group.getThreshold(i)) continue;
                thresholdIndex = i;
                break;
            }
        }
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editThreshold");
        modelAndView.addObject("threshold", (Object)threshold);
        modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)true);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private ModelAndView gotoNewExpression(String groupName) {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        Group group = configFactory.getGroup(groupName);
        int expressionIndex = group.getExpressionCount();
        Expression expression = null;
        if (expressionIndex > 0) {
            expression = group.getExpression(expressionIndex - 1);
            if (expression.getExpression() == null || expression.getExpression().equals("")) {
                --expressionIndex;
            } else {
                expression = null;
            }
        }
        if (expression == null) {
            expression = new Expression();
            expression.setDsType("node");
            expression.setType("high");
            expression.setTrigger(1);
            group.addExpression(expression);
        }
        if (expression != group.getExpression(expressionIndex)) {
            for (int i = 0; i < group.getExpressionCount(); ++i) {
                if (expression != group.getExpression(i)) continue;
                expressionIndex = i;
                break;
            }
        }
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editExpression");
        modelAndView.addObject("expression", (Object)expression);
        modelAndView.addObject("expressionIndex", (Object)expressionIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)true);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private ModelAndView gotoEditThreshold(String thresholdIndexString, String groupName) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to edit a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        Threshold threshold = configFactory.getGroup(groupName).getThreshold(thresholdIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editThreshold");
        modelAndView.addObject("threshold", (Object)threshold);
        modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)false);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private void moveThresholdFilter(Basethresholddef threshold, int oldPos, int newPos) {
        if (newPos >= 0 && newPos < threshold.getResourceFilterCount()) {
            ResourceFilter oldFilter = (ResourceFilter)threshold.getResourceFilterCollection().get(oldPos);
            ResourceFilter newFilter = (ResourceFilter)threshold.getResourceFilterCollection().get(newPos);
            threshold.getResourceFilterCollection().set(newPos, oldFilter);
            threshold.getResourceFilterCollection().set(oldPos, newFilter);
        }
    }

    private List<ResourceFilter> getFilterList(HttpServletRequest request, boolean create) {
        return (List)request.getSession(create).getAttribute("savedFilters");
    }

    private void setFilterList(HttpServletRequest request, List<ResourceFilter> filters) {
        if (filters == null) {
            request.getSession(false).removeAttribute("savedFilters");
        } else {
            request.getSession(false).setAttribute("savedFilters", filters);
        }
    }

    private ModelAndView finishThresholdFilterEdit(HttpServletRequest request, Basethresholddef threshold) throws ServletException {
        String stringIndex;
        boolean isExpression = threshold instanceof Expression;
        int thresholdIndex = isExpression ? WebSecurityUtils.safeParseInt((String)request.getParameter("expressionIndex")) : WebSecurityUtils.safeParseInt((String)request.getParameter("thresholdIndex"));
        ModelAndView modelAndView = isExpression ? new ModelAndView("admin/thresholds/editExpression") : new ModelAndView("admin/thresholds/editThreshold");
        List<ResourceFilter> saved = this.getFilterList(request, true);
        if (saved == null || saved.size() == 0) {
            saved = new ArrayList<ResourceFilter>(threshold.getResourceFilterCollection());
            this.setFilterList(request, saved);
        }
        int filterIndex = (stringIndex = request.getParameter("filterSelected")) != null && !stringIndex.equals("") ? WebSecurityUtils.safeParseInt((String)stringIndex) - 1 : 0;
        String submitAction = request.getParameter("submitAction");
        if (ADDFILTER_BUTTON_TITLE.equals(submitAction)) {
            String field = request.getParameter("filterField");
            String content = request.getParameter("filterRegexp");
            if (field != null && !field.equals("") && content != null && !content.equals("")) {
                ResourceFilter filter = new ResourceFilter();
                filter.setField(field);
                filter.setContent(content);
                threshold.addResourceFilter(filter);
            }
        } else if (DELETE_BUTTON_TITLE.equals(submitAction)) {
            threshold.getResourceFilterCollection().remove(filterIndex);
        } else if (EDIT_BUTTON_TITLE.equals(submitAction)) {
            modelAndView.addObject("filterSelected", (Object)request.getParameter("filterSelected"));
        } else if (UPDATE_BUTTON_TITLE.equals(submitAction)) {
            ResourceFilter filter = (ResourceFilter)threshold.getResourceFilterCollection().get(filterIndex);
            filter.setField(request.getParameter("updateFilterField"));
            filter.setContent(request.getParameter("updateFilterRegexp"));
        } else if (MOVEUP_BUTTON_TITLE.equals(submitAction)) {
            this.moveThresholdFilter(threshold, filterIndex, filterIndex - 1);
        } else if (MOVEDOWN_BUTTON_TITLE.equals(submitAction)) {
            this.moveThresholdFilter(threshold, filterIndex, filterIndex + 1);
        }
        this.commonFinishEdit(request, threshold);
        if (isExpression) {
            ((Expression)threshold).setExpression(request.getParameter("expression"));
        } else {
            ((Threshold)threshold).setDsName(request.getParameter("dsName"));
        }
        String isNew = request.getParameter("isNew");
        if ("true".equals(isNew)) {
            modelAndView.addObject("isNew", (Object)true);
        }
        if (isExpression) {
            modelAndView.addObject("expression", (Object)threshold);
            modelAndView.addObject("expressionIndex", (Object)thresholdIndex);
        } else {
            modelAndView.addObject("threshold", (Object)threshold);
            modelAndView.addObject("thresholdIndex", (Object)thresholdIndex);
        }
        modelAndView.addObject("groupName", (Object)request.getParameter("groupName"));
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private ModelAndView gotoEditExpression(String expressionIndexString, String groupName) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to edit a threshold");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        Expression expression = configFactory.getGroup(groupName).getExpression(expressionIndex);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editExpression");
        modelAndView.addObject("expression", (Object)expression);
        modelAndView.addObject("expressionIndex", (Object)expressionIndex);
        modelAndView.addObject("groupName", (Object)groupName);
        modelAndView.addObject("isNew", (Object)false);
        this.addStandardEditingBits(modelAndView);
        return modelAndView;
    }

    private EventBuilder createEventBuilder(String uei) {
        EventBuilder ebldr = new EventBuilder(uei, "Web UI");
        ebldr.setHost(InetAddressUtils.getLocalHostName());
        return ebldr;
    }

    private void sendNotifEvent(org.opennms.netmgt.xml.event.Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }

    private void saveChanges() throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        try {
            configFactory.saveCurrent();
            EventBuilder ebldr = this.createEventBuilder("uei.opennms.org/internal/reloadDaemonConfig");
            ebldr.addParam("daemonName", "Threshd");
            ebldr.addParam("configFile", "thresholds.xml");
            this.sendNotifEvent(ebldr.getEvent());
        }
        catch (Throwable e) {
            throw new ServletException("Could not save the changes to the threshold because " + e.getMessage(), e);
        }
        if (this.eventConfChanged) {
            try {
                EventconfFactory.getInstance().saveCurrent();
                this.sendNotifEvent(this.createEventBuilder("uei.opennms.org/internal/eventsConfigChange").getEvent());
            }
            catch (Throwable e) {
                throw new ServletException("Could not save the changes to the event configuration because " + e.getMessage(), e);
            }
            this.eventConfChanged = false;
        }
    }

    private ModelAndView deleteThreshold(String thresholdIndexString, String groupName) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to delete a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        Group group = configFactory.getGroup(groupName);
        group.removeThreshold(group.getThreshold(thresholdIndex));
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)configFactory.getGroup(groupName));
        this.saveChanges();
        return modelAndView;
    }

    private ModelAndView reloadThreshdConfig() throws ServletException {
        try {
            EventBuilder ebldr = this.createEventBuilder("uei.opennms.org/internal/reloadDaemonConfig");
            ebldr.addParam("daemonName", "Threshd");
            ebldr.addParam("configFile", "threshd-configuration.xml");
            this.sendNotifEvent(ebldr.getEvent());
        }
        catch (Throwable e) {
            throw new ServletException("Could not reload threshd-configuration.xml because " + e.getMessage(), e);
        }
        return this.gotoGroupList();
    }

    private ModelAndView deleteExpression(String expressionIndexString, String groupName) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to delete a threshold expression");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        Group group = configFactory.getGroup(groupName);
        group.removeExpression(group.getExpression(expressionIndex));
        this.saveChanges();
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)configFactory.getGroup(groupName));
        return modelAndView;
    }

    private void commonFinishEdit(HttpServletRequest request, Basethresholddef baseDef) {
        String dsLabel = request.getParameter("dsLabel");
        if (dsLabel == null || "".equals(dsLabel)) {
            baseDef.setDsLabel(null);
        } else {
            baseDef.setDsLabel(dsLabel);
        }
        String description = request.getParameter("description");
        if (description == null || "".equals(description)) {
            baseDef.setDescription(null);
        } else {
            baseDef.setDescription(description);
        }
        String triggeredUEI = request.getParameter("triggeredUEI");
        if (triggeredUEI == null || "".equals(triggeredUEI)) {
            baseDef.setTriggeredUEI(null);
        } else {
            baseDef.setTriggeredUEI(triggeredUEI);
            this.ensureUEIInEventConf(triggeredUEI, "exceeded");
        }
        String rearmedUEI = request.getParameter("rearmedUEI");
        if (rearmedUEI == null || "".equals(rearmedUEI)) {
            baseDef.setRearmedUEI(null);
        } else {
            baseDef.setRearmedUEI(rearmedUEI);
            this.ensureUEIInEventConf(rearmedUEI, "rearmed");
        }
        baseDef.setDsType(request.getParameter("dsType"));
        baseDef.setType(request.getParameter("type"));
        baseDef.setRearm(WebSecurityUtils.safeParseDouble((String)request.getParameter("rearm")));
        baseDef.setTrigger(WebSecurityUtils.safeParseInt((String)request.getParameter("trigger")));
        baseDef.setValue(WebSecurityUtils.safeParseDouble((String)request.getParameter("value")));
    }

    private void ensureUEIInEventConf(String uei, String typeDesc) {
        List eventsForUEI = EventconfFactory.getInstance().getEvents(uei);
        if (eventsForUEI == null || eventsForUEI.size() == 0) {
            Event event = new Event();
            event.setUei(uei);
            event.setEventLabel("User-defined threshold event " + uei);
            event.setDescr("Threshold " + typeDesc + " for %service% datasource " + "%parm[ds]% on interface %interface%, parms: %parm[all]%");
            Logmsg logmsg = new Logmsg();
            logmsg.setDest("logndisplay");
            logmsg.setContent("Threshold " + typeDesc + " for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
            event.setLogmsg(logmsg);
            event.setSeverity("Warning");
            EventconfFactory.getInstance().addEventToProgrammaticStore(event);
            this.eventConfChanged = true;
        }
    }

    private ModelAndView finishThresholdEdit(HttpServletRequest request) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        String groupName = request.getParameter("groupName");
        String submitAction = request.getParameter("submitAction");
        Group group = configFactory.getGroup(groupName);
        String thresholdIndexString = request.getParameter("thresholdIndex");
        if (thresholdIndexString == null) {
            throw new ServletException("thresholdIndex parameter required to modify or delete a threshold");
        }
        int thresholdIndex = WebSecurityUtils.safeParseInt((String)thresholdIndexString);
        Threshold threshold = group.getThreshold(thresholdIndex);
        if (SAVE_BUTTON_TITLE.equals(submitAction)) {
            this.commonFinishEdit(request, (Basethresholddef)threshold);
            String dsName = request.getParameter("dsName");
            if (dsName == null || dsName.equals("")) {
                throw new ServletException("ds-name cannot be null or empty string");
            }
            threshold.setDsName(dsName);
            threshold.setFilterOperator(request.getParameter("filterOperator"));
            this.saveChanges();
        } else if (CANCEL_BUTTON_TITLE.equals(submitAction)) {
            String isNew = request.getParameter("isNew");
            if ("true".equals(isNew)) {
                group.removeThreshold(threshold);
            } else {
                List<ResourceFilter> filters = this.getFilterList(request, false);
                if (filters != null) {
                    threshold.setResourceFilter(filters);
                }
            }
        } else {
            return this.finishThresholdFilterEdit(request, (Basethresholddef)threshold);
        }
        this.setFilterList(request, null);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)group);
        return modelAndView;
    }

    private ModelAndView finishExpressionEdit(HttpServletRequest request) throws ServletException {
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        String groupName = request.getParameter("groupName");
        String submitAction = request.getParameter("submitAction");
        Group group = configFactory.getGroup(groupName);
        String expressionIndexString = request.getParameter("expressionIndex");
        if (expressionIndexString == null) {
            throw new ServletException("expressionIndex parameter required to modify or delete a threshold expression");
        }
        int expressionIndex = WebSecurityUtils.safeParseInt((String)expressionIndexString);
        Expression expression = group.getExpression(expressionIndex);
        if (SAVE_BUTTON_TITLE.equals(submitAction)) {
            this.commonFinishEdit(request, (Basethresholddef)expression);
            String expDef = request.getParameter("expression");
            if (expDef == null || expDef.equals("")) {
                throw new ServletException("expression content cannot be null or empty string");
            }
            expression.setExpression(expDef);
            expression.setFilterOperator(request.getParameter("filterOperator"));
            this.saveChanges();
        } else if (CANCEL_BUTTON_TITLE.equals(submitAction)) {
            String isNew = request.getParameter("isNew");
            if ("true".equals(isNew)) {
                group.removeExpression(expression);
            } else {
                List<ResourceFilter> filters = this.getFilterList(request, false);
                if (filters != null) {
                    expression.setResourceFilter(filters);
                }
            }
        } else {
            return this.finishThresholdFilterEdit(request, (Basethresholddef)expression);
        }
        this.setFilterList(request, null);
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/editGroup");
        modelAndView.addObject("group", (Object)configFactory.getGroup(groupName));
        return modelAndView;
    }

    private ModelAndView gotoGroupList() throws ServletException {
        try {
            ThresholdingConfigFactory.reload();
        }
        catch (Throwable e) {
            throw new ServletException("Could not reload ThresholdingConfigFactory because " + e.getMessage(), e);
        }
        ThresholdingConfigFactory configFactory = ThresholdingConfigFactory.getInstance();
        ModelAndView modelAndView = new ModelAndView("admin/thresholds/list");
        HashMap<String, Group> groupMap = new HashMap<String, Group>();
        for (String aName : configFactory.getGroupNames()) {
            groupMap.put(aName, configFactory.getGroup(aName));
        }
        modelAndView.addObject("groupMap", groupMap);
        return modelAndView;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }
}

