/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.web.api.Util;
import org.opennms.web.category.CategoryModel;

public class RTCPostServlet
extends HttpServlet {
    private static final long serialVersionUID = 5550051932055498432L;
    protected CategoryModel model;
    protected ThreadCategory log = ThreadCategory.getInstance((String)"RTC");

    public void init() throws ServletException {
        try {
            this.model = CategoryModel.getInstance();
        }
        catch (IOException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
        catch (MarshalException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new ServletException("Could not instantiate the CategoryModel", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            this.log.error("Request with no path info");
            response.sendError(400, "No Category name given in path");
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1, pathInfo.length());
        }
        String categoryName = Util.decode((String)pathInfo);
        Category category = null;
        try {
            ServletInputStream inStream = request.getInputStream();
            EuiLevel level = (EuiLevel)CastorUtils.unmarshal(EuiLevel.class, (InputStream)inStream);
            category = level.getCategory(0);
        }
        catch (MarshalException ex) {
            this.log.error("Failed to load configuration", (Throwable)ex);
            response.sendError(400, "Invalid XML input: MarshalException: " + ex.getMessage());
            return;
        }
        catch (ValidationException ex) {
            this.log.error("Failed to load configuration", (Throwable)ex);
            response.sendError(400, "Invalid XML input: ValidationException" + ex.getMessage());
            return;
        }
        if (!categoryName.equals(category.getCatlabel())) {
            this.log.error("Request did not supply information for category specified in path info");
            response.sendError(400, "No category info found for " + categoryName);
            return;
        }
        this.model.updateCategory(category);
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("Category data parsed successfully.");
        out.close();
        this.log.info("Successfully received information for " + categoryName);
    }
}

