/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.filter.Filter;

public class AlarmCriteria {
    Filter[] m_filters = null;
    SortStyle m_sortStyle = SortStyle.LASTEVENTTIME;
    AcknowledgeType m_ackType = AcknowledgeType.UNACKNOWLEDGED;
    int m_limit = -1;
    int m_offset = -1;

    public AlarmCriteria(Filter ... filters) {
        this(filters, null, null, -1, -1);
    }

    public AlarmCriteria(AcknowledgeType ackType, Filter[] filters) {
        this(filters, null, ackType, -1, -1);
    }

    public AlarmCriteria(Filter[] filters, SortStyle sortStyle, AcknowledgeType ackType, int limit, int offset) {
        this.m_filters = filters;
        this.m_sortStyle = sortStyle;
        this.m_ackType = ackType;
        this.m_limit = limit;
        this.m_offset = offset;
    }

    public <E extends Exception> void visit(AlarmCriteriaVisitor<E> visitor) throws E {
        if (this.m_ackType != null) {
            visitor.visitAckType(this.m_ackType);
        }
        for (Filter filter : this.m_filters) {
            visitor.visitFilter(filter);
        }
        if (this.m_sortStyle != null) {
            visitor.visitSortStyle(this.m_sortStyle);
        }
        if (this.m_limit > 0 && this.m_offset > -1) {
            visitor.visitLimit(this.m_limit, this.m_offset);
        }
    }

    public static class BaseAlarmCriteriaVisitor<E extends Exception>
    implements AlarmCriteriaVisitor<E> {
        @Override
        public void visitAckType(AcknowledgeType ackType) throws E {
        }

        @Override
        public void visitFilter(Filter filter) throws E {
        }

        @Override
        public void visitLimit(int limit, int offset) throws E {
        }

        @Override
        public void visitSortStyle(SortStyle sortStyle) throws E {
        }
    }

    public static interface AlarmCriteriaVisitor<E extends Exception> {
        public void visitAckType(AcknowledgeType var1) throws E;

        public void visitFilter(Filter var1) throws E;

        public void visitSortStyle(SortStyle var1) throws E;

        public void visitLimit(int var1, int var2) throws E;
    }
}

