/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmIdFilter;
import org.opennms.web.alarm.filter.AlarmIdListFilter;
import org.opennms.web.alarm.filter.AlarmTypeFilter;
import org.opennms.web.alarm.filter.SeverityBetweenFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.AndFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OrFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

@Deprecated
public class JdbcWebAlarmRepository
implements WebAlarmRepository,
InitializingBean {
    @Autowired
    SimpleJdbcTemplate m_simpleJdbcTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    private String getSql(String selectClause, AlarmCriteria criteria) {
        final StringBuilder buf = new StringBuilder(selectClause);
        criteria.visit(new AlarmCriteria.AlarmCriteriaVisitor<RuntimeException>(){
            boolean first = true;

            public void and(StringBuilder buf2) {
                if (this.first) {
                    buf2.append(" WHERE ");
                    this.first = false;
                } else {
                    buf2.append(" AND ");
                }
            }

            @Override
            public void visitAckType(AcknowledgeType ackType) {
                this.and(buf);
                buf.append(ackType.getAcknowledgeTypeClause());
            }

            @Override
            public void visitFilter(Filter filter) {
                this.and(buf);
                buf.append(filter.getParamSql());
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) {
                buf.append(" ");
                buf.append(sortStyle.getOrderByClause());
            }

            @Override
            public void visitLimit(int limit, int offset) {
                buf.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
            }
        });
        return buf.toString();
    }

    private PreparedStatementSetter paramSetter(final AlarmCriteria criteria, final Object ... args) {
        return new PreparedStatementSetter(){
            int paramIndex = 1;

            public void setValues(final PreparedStatement ps) throws SQLException {
                for (Object arg : args) {
                    ps.setObject(this.paramIndex, arg);
                    ++this.paramIndex;
                }
                criteria.visit(new AlarmCriteria.BaseAlarmCriteriaVisitor<SQLException>(){

                    @Override
                    public void visitFilter(Filter filter) throws SQLException {
                        paramIndex += filter.bindParam(ps, paramIndex);
                    }
                });
            }
        };
    }

    @Override
    public void updateStickyMemo(Integer alarmId, String body, String user) {
        throw new UnsupportedOperationException("Not supported yet. JdbcWebAlarmRepositony is deprecated.");
    }

    @Override
    public void updateReductionKeyMemo(Integer alarmId, String body, String user) {
        throw new UnsupportedOperationException("Not supported yet. JdbcWebAlarmRepositony is deprecated.");
    }

    @Override
    public void removeStickyMemo(Integer alarmId) {
        throw new UnsupportedOperationException("Not supported yet. JdbcWebAlarmRepositony is deprecated.");
    }

    @Override
    public void removeReductionKeyMemo(int alarmId) {
        throw new UnsupportedOperationException("Not supported yet. JdbcWebAlarmRepositony is deprecated.");
    }

    @Override
    public int countMatchingAlarms(AlarmCriteria criteria) {
        String sql = this.getSql("SELECT COUNT(ALARMID) as ALARMCOUNT FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ", criteria);
        return this.queryForInt(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public int[] countMatchingAlarmsBySeverity(AlarmCriteria criteria) {
        String selectClause = "SELECT SEVERITY, COUNT(ALARMID) AS ALARMCOUNT FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ";
        String sql = this.getSql(selectClause, criteria);
        sql = sql + " GROUP BY SEVERITY";
        final int[] alarmCounts = new int[8];
        this.jdbc().query(sql, this.paramSetter(criteria, new Object[0]), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                int alarmCount;
                int severity = rs.getInt("SEVERITY");
                alarmCounts[severity] = alarmCount = rs.getInt("ALARMCOUNT");
            }
        });
        return alarmCounts;
    }

    @Override
    public Alarm getAlarm(int alarmId) {
        Alarm[] alarms = this.getMatchingAlarms(new AlarmCriteria(new AlarmIdFilter(alarmId)));
        if (alarms.length < 1) {
            return null;
        }
        return alarms[0];
    }

    @Override
    public Alarm[] getMatchingAlarms(AlarmCriteria criteria) {
        String sql = this.getSql("SELECT ALARMS.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) ", criteria);
        return this.getAlarms(sql, this.paramSetter(criteria, new Object[0]));
    }

    private Alarm[] getAlarms(String sql, PreparedStatementSetter setter) {
        List<Alarm> alarms = this.queryForList(sql, setter, new AlarmMapper());
        return alarms.toArray(new Alarm[0]);
    }

    @Override
    public void acknowledgeAlarms(int[] alarmIds, String user, Date timestamp) {
        this.acknowledgeMatchingAlarms(user, timestamp, new AlarmCriteria(new AlarmIdListFilter(alarmIds)));
    }

    @Override
    public void acknowledgeMatchingAlarms(String user, Date timestamp, AlarmCriteria criteria) {
        String sql = this.getSql("UPDATE ALARMS SET ALARMACKUSER=?, ALARMACKTIME=? ", criteria);
        this.jdbc().update(sql, this.paramSetter(criteria, user, new Timestamp(timestamp.getTime())));
    }

    @Override
    public void acknowledgeAll(String user, Date timestamp) {
        this.m_simpleJdbcTemplate.update("UPDATE ALARMS SET ALARMACKUSER=?, ALARMACKTIME=? WHERE ALARMACKUSER IS NULL ", new Object[]{user, new Timestamp(timestamp.getTime())});
    }

    @Override
    public void unacknowledgeAlarms(int[] alarmIds, String user) {
        this.unacknowledgeMatchingAlarms(new AlarmCriteria(new AlarmIdListFilter(alarmIds)), user);
    }

    @Override
    public void unacknowledgeMatchingAlarms(AlarmCriteria criteria, String user) {
        String sql = this.getSql("UPDATE ALARMS SET ALARMACKUSER=NULL, ALARMACKTIME=NULL ", criteria);
        this.jdbc().update(sql, this.paramSetter(criteria, new Object[0]));
    }

    @Override
    public void unacknowledgeAll(String user) {
        this.m_simpleJdbcTemplate.update("UPDATE ALARMS SET ALARMACKUSER=NULL, ALARMACKTIME=NULL WHERE ALARMACKUSER IS NOT NULL ", new Object[0]);
    }

    public void clearAlarms(int[] alarmIds, String user) {
        this.clearAlarms(alarmIds, user, new Date());
    }

    @Override
    public void clearAlarms(int[] alarmIds, String user, Date timestamp) {
        if (alarmIds == null || user == null || timestamp == null) {
            throw new IllegalArgumentException("Cannot take null parameters");
        }
        AlarmCriteria criteria = new AlarmCriteria(new AlarmIdListFilter(alarmIds), new SeverityBetweenFilter(OnmsSeverity.NORMAL, OnmsSeverity.CRITICAL));
        String sql = this.getSql("UPDATE ALARMS SET SEVERITY =?, ALARMTYPE =? ", criteria);
        LogUtils.infof((Object)this, (String)sql, (Object[])new Object[0]);
        this.jdbc().update(sql, this.paramSetter(criteria, OnmsSeverity.CLEARED.getId(), 2));
    }

    @Override
    public void escalateAlarms(int[] alarmIds, String user, Date timestamp) {
        AndFilter condFilter = new AndFilter(new AlarmTypeFilter(1), new SeverityFilter(OnmsSeverity.CLEARED));
        AndFilter condFilter2 = new AndFilter(new AlarmTypeFilter(1), new SeverityBetweenFilter(OnmsSeverity.CLEARED, OnmsSeverity.CRITICAL));
        OrFilter orCondFilter = new OrFilter(condFilter, condFilter2);
        AlarmCriteria criteria = new AlarmCriteria(new AlarmIdListFilter(alarmIds), orCondFilter);
        String sql = this.getSql("UPDATE ALARMS SET SEVERITY = ( CASE WHEN SEVERITY =? THEN ? ELSE ( CASE WHEN SEVERITY <? THEN SEVERITY + 1 ELSE ? END) END), ALARMTYPE =? ", criteria);
        LogUtils.infof((Object)this, (String)sql, (Object[])new Object[0]);
        this.jdbc().update(sql, this.paramSetter(criteria, OnmsSeverity.CLEARED.getId(), OnmsSeverity.WARNING.getId(), OnmsSeverity.CRITICAL.getId(), OnmsSeverity.CRITICAL.getId(), 1));
    }

    private int queryForInt(String sql, PreparedStatementSetter setter) throws DataAccessException {
        Integer number = (Integer)this.queryForObject(sql, setter, (RowMapper)new SingleColumnRowMapper(Integer.class));
        return number != null ? number : 0;
    }

    private <T> T queryForObject(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper, 1))));
    }

    private <T> List<T> queryForList(String sql, PreparedStatementSetter setter, ParameterizedRowMapper<T> rm) {
        return (List)this.jdbc().query(sql, setter, (ResultSetExtractor)new RowMapperResultSetExtractor(rm));
    }

    private JdbcOperations jdbc() {
        return this.m_simpleJdbcTemplate.getJdbcOperations();
    }

    private static class AlarmMapper
    implements ParameterizedRowMapper<Alarm> {
        private AlarmMapper() {
        }

        public Alarm mapRow(ResultSet rs, int rowNum) throws SQLException {
            Alarm alarm = new Alarm();
            alarm.id = rs.getInt("alarmID");
            alarm.uei = rs.getString("eventUei");
            alarm.dpName = rs.getString("dpName");
            alarm.nodeID = new Integer(rs.getInt("nodeID"));
            alarm.ipAddr = rs.getString("ipAddr");
            alarm.serviceID = (Integer)rs.getObject("serviceID");
            alarm.reductionKey = rs.getString("reductionKey");
            alarm.count = rs.getInt("counter");
            alarm.severity = OnmsSeverity.get((int)rs.getInt("severity"));
            alarm.lastEventID = rs.getInt("lastEventID");
            alarm.firsteventtime = this.getTimestamp("firsteventtime", rs);
            alarm.lasteventtime = this.getTimestamp("lasteventtime", rs);
            alarm.description = rs.getString("description");
            alarm.logMessage = rs.getString("logmsg");
            alarm.operatorInstruction = rs.getString("OperInstruct");
            alarm.troubleTicket = rs.getString("TTicketID");
            Integer stateCode = (Integer)rs.getObject("TTicketState");
            for (TroubleTicketState state : TroubleTicketState.values()) {
                if (stateCode == null || state.ordinal() != stateCode.intValue()) continue;
                alarm.troubleTicketState = state;
            }
            alarm.mouseOverText = rs.getString("MouseOverText");
            alarm.suppressedUntil = this.getTimestamp("suppressedUntil", rs);
            alarm.suppressedUser = rs.getString("suppressedUser");
            alarm.suppressedTime = this.getTimestamp("suppressedTime", rs);
            alarm.acknowledgeUser = rs.getString("alarmAckUser");
            alarm.acknowledgeTime = this.getTimestamp("alarmAckTime", rs);
            alarm.nodeLabel = rs.getString("nodeLabel");
            alarm.serviceName = rs.getString("serviceName");
            return alarm;
        }

        private Date getTimestamp(String field, ResultSet rs) throws SQLException {
            if (rs.getTimestamp(field) != null) {
                return new Date(rs.getTimestamp(field).getTime());
            }
            return null;
        }
    }
}

