/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.views.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.web.admin.views.parsers.Category;

public class View
implements Cloneable {
    private String m_viewName;
    private String m_viewTitle;
    private String m_viewComments;
    private String m_commonRule;
    private List<String> m_userMembers = new ArrayList<String>();
    private List<String> m_groupMembers = new ArrayList<String>();
    private List<Category> m_categories = new ArrayList<Category>();

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        View newView = new View();
        newView.setViewName(this.m_viewName);
        newView.setViewTitle(this.m_viewTitle);
        newView.setViewComments(this.m_viewComments);
        newView.setCommon(this.m_commonRule);
        for (String userMember : this.m_userMembers) {
            newView.addUserMember(userMember);
        }
        for (String groupMember : this.m_groupMembers) {
            newView.addGroupMember(groupMember);
        }
        for (Category category : this.m_categories) {
            newView.addCategory(category.clone());
        }
        return newView;
    }

    public void setViewName(String aValue) {
        this.m_viewName = aValue;
    }

    public void setViewTitle(String aValue) {
        this.m_viewTitle = aValue;
    }

    public void setViewComments(String aValue) {
        this.m_viewComments = aValue;
    }

    public void setCommon(String common) {
        this.m_commonRule = common;
    }

    public String getCommon() {
        return this.m_commonRule;
    }

    public void addCategory(Category aCategory) {
        this.m_categories.add(aCategory);
    }

    public String getViewName() {
        return this.m_viewName;
    }

    public String getViewTitle() {
        return this.m_viewTitle;
    }

    public String getViewComments() {
        return this.m_viewComments;
    }

    public List<String> getUserMembers() {
        return this.m_userMembers;
    }

    public void setUserMembers(List<String> users) {
        this.m_userMembers = users;
    }

    public void addUserMember(String aMember) {
        this.m_userMembers.add(aMember);
    }

    public void removeUserMember(String aMember) {
        this.m_userMembers.remove(aMember);
    }

    public void clearUserMembers() {
        this.m_userMembers.clear();
    }

    public List<String> getGroupMembers() {
        return this.m_groupMembers;
    }

    public void setGroupMembers(List<String> groups) {
        this.m_groupMembers = groups;
    }

    public List<String> getMembers() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.m_userMembers);
        all.addAll(this.m_groupMembers);
        return all;
    }

    public void addGroupMember(String aMember) {
        this.m_groupMembers.add(aMember);
    }

    public void removeGroupMember(String aMember) {
        this.m_groupMembers.remove(aMember);
    }

    public void clearGroupMembers() {
        this.m_groupMembers.clear();
    }

    public boolean hasUserMember(String name) {
        return this.m_userMembers.contains(name);
    }

    public boolean hasGroupMember(String name) {
        return this.m_groupMembers.contains(name);
    }

    public List<Category> getCategories() {
        return this.m_categories;
    }

    public Map<String, Category> getCategoriesMap() {
        HashMap<String, Category> categoriesMap = new HashMap<String, Category>();
        for (Category category : this.m_categories) {
            categoriesMap.put(category.getLabel(), category);
        }
        return categoriesMap;
    }

    public void setCategories(List<Category> categories) {
        this.m_categories = categories;
    }

    public void setCategories(Map<String, Category> categories) {
        this.m_categories.clear();
        for (Category category : categories.values()) {
            this.m_categories.add(category);
        }
    }

    public int getCategoryCount() {
        return this.m_categories.size();
    }
}

