/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.views.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Category
implements Cloneable {
    private String m_label;
    private String m_rule;
    private String m_normal;
    private String m_warning;
    private List<String> m_services;
    private String m_comments;

    public Category() {
        this.m_services = new ArrayList<String>();
    }

    public Category(String aLabel, String aRule, String aNormal, String aWarning) {
        this.m_label = aLabel;
        this.m_rule = aRule;
        this.m_normal = aNormal;
        this.m_warning = aWarning;
        this.m_comments = "";
        this.m_services = new ArrayList<String>();
    }

    public Category clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        Category newCategory = new Category(this.m_label, this.m_rule, this.m_normal, this.m_warning);
        newCategory.setComments(this.m_comments);
        for (String service : this.m_services) {
            newCategory.addService(service);
        }
        return newCategory;
    }

    public Category(String aDataString) {
        StringTokenizer tokens = new StringTokenizer(aDataString, "$");
        while (tokens.hasMoreTokens()) {
            this.m_label = tokens.nextToken();
            String normal = tokens.nextToken();
            try {
                Float.valueOf(normal);
                this.m_normal = normal;
                this.m_warning = tokens.nextToken();
                this.m_rule = tokens.nextToken();
            }
            catch (NumberFormatException e) {}
        }
    }

    public void setLabel(String aValue) {
        this.m_label = aValue;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setRule(String aValue) {
        this.m_rule = aValue;
    }

    public String getRule() {
        return this.m_rule;
    }

    public void setNormal(String aValue) {
        this.m_normal = aValue;
    }

    public String getNormal() {
        return this.m_normal;
    }

    public void setWarning(String aValue) {
        this.m_warning = aValue;
    }

    public String getWarning() {
        return this.m_warning;
    }

    public void addService(String name) {
        this.m_services.add(name);
    }

    public List<String> getServices() {
        return this.m_services;
    }

    public void setServices(List<String> services) {
        this.m_services = services;
    }

    public void setComments(String comment) {
        this.m_comments = comment;
    }

    public String getComments() {
        return this.m_comments;
    }

    public String getUserManagerFormat() {
        return this.m_label + "$" + this.m_normal + "$" + this.m_warning + "$" + this.m_rule + "#";
    }
}

