/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.admin.nodeManagement.SnmpManagedInterface;
import org.opennms.web.api.Util;
import org.opennms.web.element.NetworkElementFactory;

public class SnmpManageNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1604691299928314549L;
    private static final String UPDATE_INTERFACE = "UPDATE snmpInterface SET snmpCollect = ? WHERE id = ?";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize database factory: " + e.getMessage(), e);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize notification factory: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        List<SnmpManagedInterface> allInterfaces = this.getManagedInterfacesFromSession(userSession);
        String nodeIdString = request.getParameter("node");
        int currNodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        String primeInt = null;
        for (SnmpManagedInterface testInterface : allInterfaces) {
            if (testInterface.getNodeid() != currNodeId || !PrimaryType.PRIMARY.getCode().equals(testInterface.getStatus())) continue;
            primeInt = NetworkElementFactory.getInstance(this.getServletContext()).getIpPrimaryAddress(currNodeId);
        }
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection connection = Vault.getDbConnection();
            d.watch((Object)connection);
            try {
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(UPDATE_INTERFACE);
                d.watch((Object)stmt);
                for (SnmpManagedInterface curInterface : allInterfaces) {
                    String option = request.getParameter("collect-" + curInterface.getIfIndex());
                    LogUtils.debugf((Object)((Object)this), (String)"option = %s", (Object[])new Object[]{option});
                    stmt.setString(1, option);
                    stmt.setInt(2, curInterface.getSnmpInterfaceId());
                    stmt.execute();
                }
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        if (primeInt != null) {
            this.sendSNMPRestartEvent(currNodeId, primeInt);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/element/node.jsp?node=" + currNodeId);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<SnmpManagedInterface> getManagedInterfacesFromSession(HttpSession userSession) {
        if (userSession == null) {
            return null;
        }
        return (List)userSession.getAttribute("listInterfacesForNode.snmpselect.jsp");
    }

    private void sendSNMPRestartEvent(int nodeid, String primeInt) throws ServletException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "web ui");
        bldr.setNodeid((long)nodeid);
        bldr.setInterface(InetAddressUtils.addr((String)primeInt));
        this.sendEvent(bldr.getEvent());
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }
}

