/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.web.api.Util;

public class SnmpConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 2824294300141467193L;
    private static final Logger log = Logger.getLogger(SnmpConfigServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String firstIPAddress = request.getParameter("firstIPAddress");
        String lastIPAddress = request.getParameter("lastIPAddress");
        String communityString = request.getParameter("communityString");
        String timeout = request.getParameter("timeout");
        String version = request.getParameter("version");
        String retryCount = request.getParameter("retryCount");
        String port = request.getParameter("port");
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPost: firstIPAddress=" + firstIPAddress + ", " + "lastIPAddress=" + lastIPAddress + ", and " + "communityString=" + communityString));
        }
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/configureSNMP", "web ui");
        bldr.setInterface(InetAddressUtils.addr((String)firstIPAddress));
        bldr.setService("SNMP");
        bldr.addParam("firstIPAddress", firstIPAddress);
        bldr.addParam("lastIPAddress", lastIPAddress);
        bldr.addParam("communityString", communityString);
        if (timeout.length() > 0) {
            bldr.addParam("timeout", timeout);
        }
        if (port.length() > 0) {
            bldr.addParam("port", port);
        }
        if (retryCount.length() > 0) {
            bldr.addParam("retryCount", retryCount);
        }
        if (version.length() > 0) {
            bldr.addParam("version", version);
        }
        try {
            EventProxy eventProxy = Util.createEventProxy();
            if (eventProxy == null) {
                throw new ServletException("Event proxy object is null, unable to send event " + bldr.getEvent().getUei());
            }
            eventProxy.send(bldr.getEvent());
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + bldr.getEvent().getUei(), e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpConfigured.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

