/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DeleteNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = 573510937493956121L;
    private File m_snmpRrdDirectory;
    private File m_rtRrdDirectory;
    private ResourceService m_resourceService;

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize database factory: " + e, e);
        }
        WebApplicationContext webAppContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.m_resourceService = (ResourceService)webAppContext.getBean("resourceService", ResourceService.class);
        this.m_snmpRrdDirectory = new File(this.m_resourceService.getRrdDirectory(), "snmp");
        this.log().debug("SNMP RRD directory: " + this.m_snmpRrdDirectory);
        this.m_rtRrdDirectory = new File(this.m_resourceService.getRrdDirectory(), "response");
        this.log().debug("Response time RRD directory: " + this.m_rtRrdDirectory);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List<Integer> nodeList = this.getList(request.getParameterValues("nodeCheck"));
        List<Integer> nodeDataList = this.getList(request.getParameterValues("nodeData"));
        for (Integer nodeId : nodeDataList) {
            List<String> ipAddrs = this.getIpAddrsForNode(nodeId);
            File nodeDir = new File(this.m_snmpRrdDirectory, nodeId.toString());
            if (nodeDir.exists() && nodeDir.isDirectory()) {
                this.log().debug("Attempting to delete node data directory: " + nodeDir.getAbsolutePath());
                if (this.deleteDir(nodeDir)) {
                    this.log().info("Node SNMP data directory deleted successfully: " + nodeDir.getAbsolutePath());
                } else {
                    this.log().warn("Node SNMP data directory *not* deleted successfully: " + nodeDir.getAbsolutePath());
                }
            }
            for (String ipAddr : ipAddrs) {
                File intfDir = new File(this.m_rtRrdDirectory, ipAddr);
                if (!intfDir.exists() || !intfDir.isDirectory()) continue;
                this.log().debug("Attempting to delete node response time data directory: " + intfDir.getAbsolutePath());
                if (this.deleteDir(intfDir)) {
                    this.log().info("Node response time data directory deleted successfully: " + intfDir.getAbsolutePath());
                    continue;
                }
                this.log().warn("Node response time data directory *not* deleted successfully: " + intfDir.getAbsolutePath());
            }
        }
        for (Integer nodeId : nodeList) {
            this.sendDeleteNodeEvent(nodeId);
            this.log().debug("End of delete of node " + nodeId);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/deleteNodesFinish.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<String> getIpAddrsForNode(Integer nodeId) throws ServletException {
        ArrayList<String> ipAddrs = new ArrayList<String>();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT ipaddr FROM ipinterface WHERE nodeid=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipAddrs.add(rs.getString("ipaddr"));
            }
        }
        catch (SQLException e) {
            throw new ServletException("There was a problem with the database connection: " + e, (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        return ipAddrs;
    }

    private void sendDeleteNodeEvent(int node) throws ServletException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/deleteNode", "web ui");
        bldr.setNodeid((long)node);
        bldr.addParam("txno", "webUI");
        this.sendEvent(bldr.getEvent());
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }

    private List<Integer> getList(String[] array) {
        if (array == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (String a : array) {
            list.add(WebSecurityUtils.safeParseInt((String)a));
        }
        return list;
    }

    private boolean deleteDir(File file) {
        boolean successful;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (this.deleteDir(child)) continue;
                return false;
            }
        }
        if (!(successful = file.delete())) {
            this.log().warn("Failed to delete file: " + file.getAbsolutePath());
        }
        return successful;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

