/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.AbstractFieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringMaxLengthValidator;

public class FieldSetTextBox
extends AbstractFieldSet
implements FieldSet,
KeyUpHandler {
    protected TextBox textBox = new TextBox();

    public FieldSetTextBox(String name, String value, String helpText) {
        super(name, helpText);
        this.init(value, -1);
    }

    @UiConstructor
    public FieldSetTextBox(String name, String value, String helpText, int maxLength) {
        super(name, helpText);
        this.init(value, maxLength);
    }

    @Override
    public String getValue() {
        return this.textBox.getText();
    }

    private void init(String value, int maxLength) {
        if (maxLength > 0) {
            this.addErrorValidator(new StringMaxLengthValidator(maxLength));
        }
        this.inititalValue = value;
        this.textBox.setText(value);
        this.textBox.setEnabled(this.enabled.booleanValue());
        this.textBox.addChangeHandler((ChangeHandler)this);
        this.textBox.addKeyUpHandler((KeyUpHandler)this);
        this.textBox.setStyleName("textBox");
        this.textBox.setSize("300px", "18px");
        this.panel.add((Widget)this.textBox);
    }

    public void onKeyUp(KeyUpEvent event) {
        this.checkField();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.textBox.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setValue(String value) {
        this.textBox.setText(value);
        this.inititalValue = value;
        this.validate(this.getValue());
    }
}

