/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.AbstractFieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.StringMaxLengthValidator;

public class FieldSetTextArea
extends AbstractFieldSet
implements FieldSet,
KeyUpHandler,
MouseUpHandler {
    private TextArea textArea = new TextArea();

    public FieldSetTextArea(String name, String value, String helpText) {
        super(name, helpText);
        this.init(value, -1);
    }

    @UiConstructor
    public FieldSetTextArea(String name, String value, String helpText, int maxLength) {
        super(name, helpText);
        this.init(value, maxLength);
    }

    @Override
    public String getValue() {
        return this.textArea.getText();
    }

    private void init(String value, int maxLength) {
        if (maxLength > 0) {
            this.addErrorValidator(new StringMaxLengthValidator(maxLength));
        }
        this.inititalValue = value;
        this.textArea.setText(value);
        this.textArea.setEnabled(this.enabled.booleanValue());
        this.textArea.addChangeHandler((ChangeHandler)this);
        this.textArea.addKeyUpHandler((KeyUpHandler)this);
        this.textArea.addMouseUpHandler((MouseUpHandler)this);
        this.textArea.setStyleName("textArea");
        this.textArea.setSize("50em", "20em");
        this.panel.add((Widget)this.textArea);
    }

    public void onKeyUp(KeyUpEvent event) {
        this.checkField();
    }

    public void onMouseUp(MouseUpEvent event) {
        this.checkField();
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.textArea.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setValue(String value) {
        this.textArea.setText(value);
        this.inititalValue = value;
        this.validate(this.getValue());
    }
}

