/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.Validator;

public abstract class AbstractFieldSet
extends Composite
implements FieldSet {
    protected VerticalPanel mainPanel = new VerticalPanel();
    protected HorizontalPanel panel = new HorizontalPanel();
    protected Label label = new Label();
    protected Boolean enabled = true;
    protected Boolean changed = false;
    protected Label errorLabel = new Label();
    protected Label warningLabel = new Label();
    protected String helpText = "";
    protected DecoratedPopupPanel popPanel = new DecoratedPopupPanel(true);
    protected ArrayList<Validator> errorValidators = new ArrayList();
    protected ArrayList<Validator> warningValidators = new ArrayList();
    protected Object inititalValue;

    public AbstractFieldSet(String name, final String helpText) {
        this.helpText = helpText;
        this.popPanel.setWidth("400px");
        if (helpText != null && !helpText.equals("")) {
            this.label.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    Widget source = ((Widget)event.getSource()).getParent();
                    int left = source.getAbsoluteLeft() + 10;
                    int top = source.getAbsoluteTop() + source.getOffsetHeight();
                    AbstractFieldSet.this.popPanel.setPopupPosition(left, top);
                    AbstractFieldSet.this.popPanel.setWidget((Widget)new HTML(helpText));
                    AbstractFieldSet.this.popPanel.show();
                }
            });
            this.label.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    AbstractFieldSet.this.popPanel.hide();
                }
            });
        }
        this.label.setText(name);
        this.label.setStyleName("label");
        this.panel.addStyleName("FieldSetHorizontalPanel");
        this.panel.add((Widget)this.label);
        this.errorLabel.setVisible(false);
        this.errorLabel.setText(null);
        this.errorLabel.setStyleName("FieldSetErrorLabel");
        this.warningLabel.setVisible(false);
        this.warningLabel.setText(null);
        this.warningLabel.setStyleName("FieldSetWarningLabel");
        this.mainPanel.add((Widget)this.errorLabel);
        this.mainPanel.add((Widget)this.warningLabel);
        this.mainPanel.add((Widget)this.panel);
        this.mainPanel.setStyleName("FieldSet");
        this.initWidget((Widget)this.mainPanel);
    }

    public void addErrorValidator(Validator validator) {
        this.errorValidators.add(validator);
    }

    public void addWarningValidator(Validator validator) {
        this.warningValidators.add(validator);
    }

    public boolean checkField() {
        if (this.getValue() != null) {
            if (!this.getValue().equals(this.inititalValue)) {
                this.mainPanel.setStyleDependentName("changed", true);
                this.changed = true;
                this.validate(this.getValue());
                return true;
            }
            if (this.getError() != "") {
                this.validate(this.getValue());
            }
        }
        this.mainPanel.setStyleDependentName("changed", false);
        this.changed = false;
        return false;
    }

    @Override
    public void clearChanged() {
        this.changed = false;
        this.mainPanel.setStyleDependentName("changed", false);
    }

    @Override
    public void clearErrors() {
        this.errorLabel.setText(null);
        this.mainPanel.setStyleDependentName("error", false);
    }

    public void clearErrorValidators() {
        this.errorValidators.clear();
    }

    @Override
    public void clearWarnings() {
        this.warningLabel.setText(null);
        this.mainPanel.setStyleDependentName("warning", false);
    }

    public void clearWarningValidators() {
        this.warningValidators.clear();
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getError() {
        return this.errorLabel.getText();
    }

    public ArrayList<Validator> getErrorValidators() {
        return this.errorValidators;
    }

    @Override
    public String getLabel() {
        return this.label.getText();
    }

    @Override
    public String getWarning() {
        return this.warningLabel.getText();
    }

    public void onChange(ChangeEvent event) {
        this.checkField();
    }

    public void onFocus(FocusEvent event) {
    }

    @Override
    public void setError(String error) {
        this.errorLabel.setText(error);
        this.errorLabel.setVisible(true);
        this.mainPanel.setStyleDependentName("error", true);
    }

    public void setErrors(ArrayList<String> errors) {
        String allErrors = "";
        for (String error : errors) {
            allErrors = allErrors + error + " ";
        }
        this.errorLabel.setText(allErrors);
        this.errorLabel.setVisible(true);
        this.mainPanel.setStyleDependentName("error", true);
    }

    public void setErrorValidators(ArrayList<Validator> validators) {
        this.errorValidators = validators;
    }

    @Override
    public void setLabel(String lable) {
        this.label.setText(lable);
    }

    @Override
    public void setWarning(String warning) {
        this.warningLabel.setText(warning);
        this.warningLabel.setVisible(true);
        this.mainPanel.setStyleDependentName("warning", true);
    }

    public void setWarnings(ArrayList<String> warnings) {
        String allWarnings = "";
        for (String warning : warnings) {
            allWarnings = allWarnings + warning + " ";
        }
        this.warningLabel.setText(allWarnings);
        this.warningLabel.setVisible(true);
        this.mainPanel.setStyleDependentName("warning", true);
    }

    public void setWarningValidators(ArrayList<Validator> validators) {
        this.warningValidators = validators;
    }

    protected void validate(Object object) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Validator validator2 : this.errorValidators) {
            Validator validator = validator2;
            if (validator.validate(object).length() <= 0) continue;
            errors.add(validator.validate(object));
        }
        if (errors.size() > 0) {
            this.setErrors(errors);
        } else {
            this.clearErrors();
        }
        ArrayList<String> warnings = new ArrayList<String>();
        for (Validator validator2 : this.warningValidators) {
            Validator validator = validator2;
            if (validator.validate(object).length() <= 0) continue;
            warnings.add(validator.validate(object));
        }
        if (warnings.size() > 0) {
            this.setWarnings(warnings);
        } else {
            this.clearWarnings();
        }
    }
}

