/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.FlexTable;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.NodeRtc;
import org.opennms.dashboard.client.PageableTableView;

class NodeStatusView
extends PageableTableView {
    private NodeRtc[] m_rtcs;

    NodeStatusView(Dashlet dashlet) {
        super(dashlet, 5, new String[]{"Node", "Current Outages", "24 Hour Availability"});
    }

    @Override
    protected void setRow(FlexTable table, int row, int elementIndex) {
        NodeRtc rtc = this.m_rtcs[elementIndex];
        if (rtc.getIsDashboardRole()) {
            table.setText(row, 0, rtc.getNodeLabel());
        } else {
            table.setHTML(row, 0, "<a href=\"element/node.jsp?node=" + rtc.getNodeId() + "\">" + rtc.getNodeLabel() + "</a>");
        }
        table.setText(row, 1, rtc.getDownServiceCount() + " of " + rtc.getServiceCount());
        table.getCellFormatter().setStyleName(row, 1, rtc.getServiceStyle());
        table.setText(row, 2, rtc.getAvailability());
        table.getCellFormatter().setStyleName(row, 2, rtc.getAvailabilityStyle());
        table.getRowFormatter().setStyleName(row, "CellStatus");
    }

    @Override
    public int getElementCount() {
        return this.m_rtcs == null ? 0 : this.m_rtcs.length;
    }

    @Override
    protected void formatCells(FlexTable table, int row) {
        table.getCellFormatter().addStyleName(row, 1, "bright");
        table.getCellFormatter().addStyleName(row, 1, "divider");
        table.getCellFormatter().addStyleName(row, 2, "bright");
        table.getCellFormatter().addStyleName(row, 2, "divider");
    }

    public void setNodeRtc(NodeRtc[] rtcs) {
        this.m_rtcs = rtcs;
        this.refresh();
    }
}

