/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Dashboard;
import org.opennms.dashboard.client.DashletLoader;
import org.opennms.dashboard.client.DashletView;
import org.opennms.dashboard.client.SurveillanceSet;

public abstract class Dashlet
extends Composite {
    private VerticalPanel m_panel = new VerticalPanel();
    private String m_title;
    private DashletTitle m_titleWidget;
    private DashletView m_view;
    private DashletLoader m_loader;
    private Dashboard m_dashboard;

    public Dashlet(Dashboard dashboard, String title) {
        this.m_title = title;
        this.m_dashboard = dashboard;
        this.initWidget((Widget)this.m_panel);
    }

    protected void setView(DashletView view) {
        this.m_view = view;
    }

    protected void setView(Widget view) {
        this.setView(new DashletView(this, view));
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
        this.m_titleWidget.setTitle(this.m_title);
    }

    public void addToTitleBar(Widget widget, DockPanel.DockLayoutConstant constraint) {
        this.m_titleWidget.add(widget, constraint);
    }

    public void setLoader(DashletLoader loader) {
        this.m_loader = loader;
    }

    protected void onLoad() {
        if (this.m_loader == null) {
            this.m_loader = new DashletLoader();
        }
        this.m_titleWidget = new DashletTitle(this.m_title, this.m_loader);
        this.m_panel.setStyleName("dashletPanel");
        this.m_panel.add((Widget)this.m_titleWidget);
        this.m_panel.add((Widget)this.m_view);
        this.m_view.onDashLoad();
    }

    protected void error(Throwable caught) {
        this.m_dashboard.error(caught);
    }

    public void error(String err) {
        this.m_dashboard.error(err);
    }

    public void setSurveillanceSet(SurveillanceSet set) {
    }

    class DashletTitle
    extends Composite {
        private DockPanel m_panel = new DockPanel();
        private Label m_label = new Label();

        DashletTitle(String title, DashletLoader loader) {
            this.m_label.setText(title);
            this.m_label.addStyleName("dashletTitle");
            this.m_panel.addStyleName("dashletTitlePanel");
            this.m_panel.add((Widget)this.m_label, DockPanel.WEST);
            this.m_panel.add((Widget)Dashlet.this.m_loader, DockPanel.EAST);
            this.m_panel.setCellVerticalAlignment((Widget)Dashlet.this.m_loader, DockPanel.ALIGN_MIDDLE);
            this.m_panel.setCellHorizontalAlignment((Widget)Dashlet.this.m_loader, DockPanel.ALIGN_RIGHT);
            this.initWidget((Widget)this.m_panel);
        }

        public void setTitle(String title) {
            this.m_label.setText(title);
        }

        public void add(Widget widget, DockPanel.DockLayoutConstant constraint) {
            this.m_panel.add(widget, constraint);
        }
    }
}

